/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.classification;

import java.util.List;
import org.nuxeo.ecm.classification.api.adapter.Classification;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.query.api.AbstractPageProvider;

public class ClassifiedPageProvider
extends AbstractPageProvider<DocumentModel> {
    public List<DocumentModel> getCurrentPage() {
        try {
            Classification classification = this.getClassification();
            if (classification != null) {
                return classification.getClassifiedDocuments();
            }
        }
        catch (ClientException e) {
            log.info((Object)e, (Throwable)e);
        }
        return null;
    }

    protected Classification getClassification() {
        DocumentModel currentDocument = this.getCurrentDocument();
        return (Classification)currentDocument.getAdapter(Classification.class);
    }

    protected DocumentModel getCurrentDocument() {
        CoreSession coreSession = (CoreSession)this.getProperties().get("coreSession");
        String docId = (String)this.getProperties().get("docId");
        try {
            return coreSession.getDocument((DocumentRef)new IdRef(docId));
        }
        catch (ClientException e) {
            return null;
        }
    }
}

