/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.classification.core;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.classification.api.ClassificationResolver;
import org.nuxeo.ecm.classification.api.ClassificationResult;
import org.nuxeo.ecm.classification.api.ClassificationService;
import org.nuxeo.ecm.classification.api.adapter.Classification;
import org.nuxeo.ecm.classification.core.ClassificationDescriptor;
import org.nuxeo.ecm.classification.core.ClassificationResolverDescriptor;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ClassificationServiceImpl
extends DefaultComponent
implements ClassificationService {
    public static final String NAME = "org.nuxeo.ecm.classification.core.ClassificationService";
    public static final String TYPES_XP = "types";
    public static final String RESOLVER_XP = "resolvers";
    protected Map<String, ClassificationResolver> resolvers = new HashMap<String, ClassificationResolver>();
    private static final Log log = LogFactory.getLog(ClassificationServiceImpl.class);
    private static List<String> typeList;

    public void activate(ComponentContext context) {
        typeList = new LinkedList<String>();
    }

    public void deactivate(ComponentContext context) {
        typeList = new LinkedList<String>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(TYPES_XP)) {
            ClassificationDescriptor classificationDesc = (ClassificationDescriptor)contribution;
            String typeName = classificationDesc.getType();
            if (classificationDesc.isEnabled().booleanValue()) {
                typeList.add(typeName);
            } else if (typeList.contains(typeName)) {
                typeList.remove(typeName);
            }
        } else if (RESOLVER_XP.equals(extensionPoint)) {
            ClassificationResolverDescriptor desc = (ClassificationResolverDescriptor)contribution;
            this.resolvers.put(desc.getName(), desc.getResolverInstance());
        } else {
            log.error((Object)("Extension point " + extensionPoint + "is unknown"));
        }
    }

    public String resolveClassification(CoreSession session, final String name, final String targetDocId) throws ClientException {
        if (!this.resolvers.containsKey(name)) {
            log.warn((Object)("reference to a missing resolver (" + name + "); returning the original doc id"));
            return targetDocId;
        }
        final String[] realTargetDocId = new String[1];
        new UnrestrictedSessionRunner(session){

            public void run() throws ClientException {
                realTargetDocId[0] = ClassificationServiceImpl.this.resolvers.get(name).resolve(this.session, targetDocId);
            }
        }.runUnrestricted();
        return realTargetDocId[0];
    }

    public List<String> getClassifiableDocumentTypes() {
        return typeList;
    }

    public boolean isClassifiable(String docType) {
        if (typeList.contains(docType)) {
            return true;
        }
        SchemaManager schemaManager = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        DocumentType documentType = schemaManager.getDocumentType(docType);
        if (documentType == null) {
            log.warn((Object)("Trying to access an unregistered DocType: " + docType));
            return false;
        }
        Set facets = documentType.getFacets();
        return facets.contains("Classifiable");
    }

    public boolean isClassifiable(DocumentModel doc) {
        return doc.hasFacet("Classifiable") || typeList.contains(doc.getType());
    }

    public ClassificationResult<ClassificationService.CLASSIFY_STATE> classify(DocumentModel classificationFolder, String resolver, Collection<DocumentModel> targetDocs) throws ClientException {
        ClassificationResult<ClassificationService.CLASSIFY_STATE> classify = this.classify(classificationFolder, targetDocs);
        Classification adapter = (Classification)classificationFolder.getAdapter(Classification.class);
        for (String docId : classify.get((Enum)ClassificationService.CLASSIFY_STATE.CLASSIFIED)) {
            adapter.addResolver(resolver, docId);
        }
        for (String docId : classify.get((Enum)ClassificationService.CLASSIFY_STATE.ALREADY_CLASSIFIED)) {
            adapter.addResolver(resolver, docId);
        }
        classificationFolder.getCoreSession().saveDocument(adapter.getDocument());
        return classify;
    }

    public ClassificationResult<ClassificationService.CLASSIFY_STATE> classify(DocumentModel classificationFolder, Collection<DocumentModel> targetDocs) throws ClientException {
        ClassificationResult result = new ClassificationResult();
        CoreSession session = classificationFolder.getCoreSession();
        if (session == null) {
            throw new ClientException("Unable to get session from classification folder");
        }
        if (!session.hasPermission(classificationFolder.getRef(), "Classify")) {
            throw new DocumentSecurityException("Not enough rights to classify doc");
        }
        String targetNotificationComment = String.format("%s:%s", session.getRepositoryName(), classificationFolder.getId());
        Classification classification = (Classification)classificationFolder.getAdapter(Classification.class);
        for (DocumentModel targetDoc : targetDocs) {
            if (!this.isClassifiable(targetDoc)) {
                result.add((Enum)ClassificationService.CLASSIFY_STATE.INVALID, targetDoc.getId());
                continue;
            }
            if (classification.contains(targetDoc.getId())) {
                result.add((Enum)ClassificationService.CLASSIFY_STATE.ALREADY_CLASSIFIED, targetDoc.getId());
                continue;
            }
            result.add((Enum)ClassificationService.CLASSIFY_STATE.CLASSIFIED, targetDoc.getId());
            classification.add(targetDoc.getId());
            String comment = String.format("%s:%s", session.getRepositoryName(), targetDoc.getId());
            ClassificationServiceImpl.notifyEvent(session, "ClassificationDone", classificationFolder, null, comment, null, null);
            ClassificationServiceImpl.notifyEvent(session, "ClassificationDone", targetDoc, null, targetNotificationComment, null, null);
        }
        session.saveDocument(classification.getDocument());
        return result;
    }

    public ClassificationResult<ClassificationService.UNCLASSIFY_STATE> unClassify(DocumentModel classificationFolder, Collection<String> targetDocs) throws ClientException {
        ClassificationResult result = new ClassificationResult();
        CoreSession session = classificationFolder.getCoreSession();
        if (session == null) {
            throw new ClientException("Unable to get session from classification folder");
        }
        if (!session.hasPermission(classificationFolder.getRef(), "Classify")) {
            throw new DocumentSecurityException("Not enough rights to unclassify on document " + classificationFolder.getPathAsString());
        }
        Classification classification = (Classification)classificationFolder.getAdapter(Classification.class);
        for (String docId : targetDocs) {
            if (classification.contains(docId)) {
                classification.remove(docId);
                result.add((Enum)ClassificationService.UNCLASSIFY_STATE.UNCLASSIFIED, docId);
                String comment = String.format("%s:%s", session.getRepositoryName(), docId);
                ClassificationServiceImpl.notifyEvent(session, "UnclassificationDone", classificationFolder, null, comment, null, null);
                DocumentModel targetDoc = session.getDocument((DocumentRef)new IdRef(docId));
                if (targetDoc == null) continue;
                String targetNotificationComment = String.format("%s:%s", session.getRepositoryName(), classificationFolder.getId());
                ClassificationServiceImpl.notifyEvent(session, "UnclassificationDone", targetDoc, null, targetNotificationComment, null, null);
                continue;
            }
            result.add((Enum)ClassificationService.UNCLASSIFY_STATE.NOT_CLASSIFIED, docId);
        }
        session.saveDocument(classification.getDocument());
        return result;
    }

    public ClassificationResult<ClassificationService.UNCLASSIFY_STATE> unClassifyFrom(Collection<DocumentModel> classificationFolders, String targetId) throws ClientException {
        ClassificationResult result = new ClassificationResult();
        if (classificationFolders == null || classificationFolders.isEmpty()) {
            throw new ClientException("Empty classification folders list");
        }
        CoreSession session = ((DocumentModel)classificationFolders.toArray()[0]).getCoreSession();
        Principal principal = session.getPrincipal();
        for (DocumentModel folder : classificationFolders) {
            if (!session.hasPermission(principal, folder.getRef(), "Classify")) {
                result.add((Enum)ClassificationService.UNCLASSIFY_STATE.NOT_ENOUGH_RIGHTS, folder.getId());
                continue;
            }
            Classification adapter = (Classification)folder.getAdapter(Classification.class);
            if (adapter == null) {
                result.add((Enum)ClassificationService.UNCLASSIFY_STATE.NOT_CLASSIFIED, folder.getId());
                continue;
            }
            if (!adapter.contains(targetId)) {
                result.add((Enum)ClassificationService.UNCLASSIFY_STATE.NOT_CLASSIFIED, folder.getId());
                continue;
            }
            adapter.remove(targetId);
            session.saveDocument(adapter.getDocument());
        }
        return result;
    }

    protected static void notifyEvent(CoreSession coreSession, String eventId, DocumentModel source, String category, String comment, String author, Map<String, Serializable> options) throws ClientException {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (options == null) {
            options = new HashMap<String, Serializable>();
        }
        options.put("repositoryName", (Serializable)((Object)coreSession.getRepositoryName()));
        if (source != null) {
            String currentLifeCycleState = null;
            try {
                currentLifeCycleState = source.getCurrentLifeCycleState();
            }
            catch (ClientException err) {
                // empty catch block
            }
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
        }
        options.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
        Principal principal = author != null ? new UserPrincipal(author) : coreSession.getPrincipal();
        DocumentEventContext ctx = new DocumentEventContext(coreSession, principal, source);
        ctx.setCategory(category);
        ctx.setComment(comment);
        ctx.setProperties(options);
        Event event = ctx.newEvent(eventId);
        try {
            EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
            log.debug((Object)("Notify RepositoryEventListener listeners list for event=" + eventId));
            evtProducer.fireEvent(event);
        }
        catch (Exception e) {
            log.error((Object)"Impossible to notify core events ! EventProducer service is missing...");
        }
    }
}

