/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.classification.api.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.classification.api.ClassificationService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.runtime.api.Framework;

public class Classification {
    protected DocumentModel document;

    public Classification(DocumentModel doc) {
        this.document = doc;
    }

    public DocumentModelList getClassifiedDocuments() throws ClientException {
        DocumentModelListImpl targets = new DocumentModelListImpl();
        CoreSession session = this.getCoreSession();
        for (String docId : this.getClassifiedDocumentIds()) {
            IdRef documentRef = new IdRef(docId);
            if (!session.exists((DocumentRef)documentRef) || !session.hasPermission((DocumentRef)documentRef, "Read")) continue;
            targets.add((Object)session.getDocument((DocumentRef)documentRef));
        }
        return targets;
    }

    public void setClassifiedDocumentIds(List<String> documents) throws ClientException {
        this.document.setPropertyValue("classification:targets", (Serializable)((Object)documents));
    }

    protected List<String> getTargetsPropertyValue() throws ClientException {
        ArrayList<String> classified = (ArrayList<String>)this.document.getPropertyValue("classification:targets");
        if (classified == null) {
            classified = new ArrayList<String>();
            this.setClassifiedDocumentIds(classified);
        }
        return classified;
    }

    public List<String> getClassifiedDocumentIds() throws ClientException {
        List<String> classified = this.getTargetsPropertyValue();
        ClassificationService service = (ClassificationService)Framework.getLocalService(ClassificationService.class);
        ArrayList<String> classifiedResolved = new ArrayList<String>();
        for (String docId : classified) {
            String resolver = this.getResolver(docId);
            if (!StringUtils.isEmpty((String)resolver)) {
                String resolved = service.resolveClassification(this.getCoreSession(), resolver, docId);
                classifiedResolved.add(resolved);
                continue;
            }
            classifiedResolved.add(docId);
        }
        return classifiedResolved;
    }

    public void add(DocumentModel doc) throws ClientException {
        this.add(doc.getId());
    }

    public void add(String resolver, String docId) throws ClientException {
        this.add(docId);
        this.addResolver(resolver, docId);
    }

    public void addResolver(String resolver, String docId) throws ClientException {
        this.removeResolver(docId);
        List<Map<String, String>> resolvers = this.getResolversDocuments();
        HashMap<String, String> entry = new HashMap<String, String>();
        entry.put("target", docId);
        entry.put("resolver", resolver);
        resolvers.add(entry);
        this.document.setPropertyValue("classification:resolvers", (Serializable)((Object)resolvers));
    }

    protected List<Map<String, String>> getResolversDocuments() throws ClientException {
        ArrayList value = (ArrayList)this.document.getPropertyValue("classification:resolvers");
        if (value == null) {
            value = new ArrayList();
        }
        return value;
    }

    protected String getResolver(String docId) throws ClientException {
        List<Map<String, String>> classifiedDocument = this.getResolversDocuments();
        for (Map<String, String> resolver : classifiedDocument) {
            if (!docId.equals(resolver.get("target"))) continue;
            return resolver.get("resolver");
        }
        return null;
    }

    protected boolean removeResolver(String docId) throws ClientException {
        List<Map<String, String>> classifiedDocument = this.getResolversDocuments();
        for (int i = 0; i < classifiedDocument.size(); ++i) {
            Map<String, String> storedResolver = classifiedDocument.get(i);
            if (!docId.equals(storedResolver.get("target"))) continue;
            classifiedDocument.remove(i);
            this.document.setPropertyValue("classification:resolvers", (Serializable)((Object)classifiedDocument));
            return true;
        }
        return false;
    }

    public void add(String docId) throws ClientException {
        List<String> classifiedDocument = this.getTargetsPropertyValue();
        classifiedDocument.add(docId);
        this.setClassifiedDocumentIds(classifiedDocument);
    }

    public boolean remove(DocumentModel doc) throws ClientException {
        return this.remove(doc.getId());
    }

    public boolean remove(String docId) throws ClientException {
        List<String> classifiedDocument = this.getTargetsPropertyValue();
        boolean removed = classifiedDocument.remove(docId);
        this.setClassifiedDocumentIds(classifiedDocument);
        if (removed) {
            this.removeResolver(docId);
        }
        return removed;
    }

    public boolean contains(DocumentModel documentModel) throws ClientException {
        return this.contains(documentModel.getId());
    }

    public boolean contains(String docId) throws ClientException {
        return this.getClassifiedDocumentIds().contains(docId);
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    protected CoreSession getCoreSession() throws ClientException {
        CoreSession session = this.document.getCoreSession();
        if (session == null) {
            throw new ClientException("Trying to resolve classified document with an offline document");
        }
        return session;
    }
}

