/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import java.time.Duration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogRecord;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.tools.command.Command;
import org.nuxeo.lib.stream.tools.renderer.Renderer;

public class CatCommand
extends Command {
    protected static final String NAME = "cat";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"n").longOpt("lines").desc("Render the first N records").hasArg().argName("N").build());
        options.addOption(Option.builder().longOpt("name").desc("Log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder().longOpt("group").desc("Consumer group").hasArg().argName("GROUP").build());
        options.addOption(Option.builder().longOpt("render").desc("Output rendering").hasArg().argName("FORMAT").build());
    }

    @Override
    public void run(LogManager manager, CommandLine cmd) throws InterruptedException {
        int limit = Integer.parseInt(cmd.getOptionValue("lines", "10"));
        String name = cmd.getOptionValue("name");
        String render = cmd.getOptionValue("render", "default");
        String group = cmd.getOptionValue("group", "tools");
        this.cat(manager, name, group, limit, this.getRecordRenderer(render));
    }

    protected void cat(LogManager manager, String name, String group, int limit, Renderer render) throws InterruptedException {
        render.header();
        try (LogTailer tailer = manager.createTailer(group, name);){
            int count = 0;
            do {
                LogRecord record;
                if ((record = tailer.read(Duration.ofMillis(1000L))) == null) {
                    break;
                }
                render.accept(record);
            } while (++count < limit);
        }
        render.footer();
    }
}

