/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.computation;

import java.util.HashMap;
import java.util.Map;

public class Settings {
    protected final int defaultConcurrency;
    protected final int defaultPartitions;
    protected final Map<String, Integer> concurrencies = new HashMap<String, Integer>();
    protected final Map<String, Integer> partitions = new HashMap<String, Integer>();

    public Settings(int defaultConcurrency, int defaultPartitions) {
        this.defaultConcurrency = defaultConcurrency;
        this.defaultPartitions = defaultPartitions;
    }

    public Settings setConcurrency(String computationName, int concurrency) {
        this.concurrencies.put(computationName, concurrency);
        return this;
    }

    public int getConcurrency(String computationName) {
        return this.concurrencies.getOrDefault(computationName, this.defaultConcurrency);
    }

    public Settings setPartitions(String streamName, int partitions) {
        this.partitions.put(streamName, partitions);
        return this;
    }

    public int getPartitions(String streamName) {
        return this.partitions.getOrDefault(streamName, this.defaultPartitions);
    }
}

