/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.chronicle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.log.chronicle.ChronicleRetentionDuration;

public class ChronicleRetentionListener
implements StoreFileListener {
    private static final Log log = LogFactory.getLog(ChronicleRetentionListener.class);
    protected final ChronicleRetentionDuration retention;
    protected SingleChronicleQueue queue;
    protected long purgedStamp;

    public ChronicleRetentionListener(ChronicleRetentionDuration retention) {
        this.retention = retention;
    }

    public void setQueue(SingleChronicleQueue queue) {
        this.queue = queue;
    }

    public void onAcquired(int cycle, File file) {
        if (this.queue == null || this.retention.disable()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Acquire Chronicle file: %s, cycle: %s", file, cycle));
        }
    }

    public synchronized void purge() {
        if (this.queue == null || this.retention.disable()) {
            return;
        }
        List<Integer> cycles = this.getAllCycles();
        int cyclesToRemove = cycles.size() - this.retention.getRetentionCycles();
        if (cyclesToRemove <= 0) {
            return;
        }
        this.purgedStamp = System.currentTimeMillis();
        cycles.subList(0, cyclesToRemove).forEach(this::dropCycle);
        this.queue.createTailer();
    }

    protected void dropCycle(Integer cycle) {
        File file = this.getFileForCycle(cycle);
        if (!file.exists()) {
            return;
        }
        log.info((Object)String.format("Deleting Chronicle file: %s according to retention: %s", file.getAbsolutePath(), this.retention));
        try {
            Files.delete(file.toPath());
            log.debug((Object)(file + " deleted"));
        }
        catch (IOException | SecurityException e) {
            log.warn((Object)String.format("Unable to delete Chronicle file: %s, %s", file.getAbsolutePath(), e.getMessage()));
        }
    }

    protected List<Integer> getAllCycles() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        try {
            NavigableSet allCycles = this.queue.listCyclesBetween(this.queue.firstCycle(), this.queue.lastCycle());
            allCycles.iterator().forEachRemaining(cycle -> ret.add(cycle.intValue()));
            return ret;
        }
        catch (ParseException e) {
            throw new RuntimeException("Fail to list cycles for queue: " + this.queue, e);
        }
    }

    protected File getFileForCycle(int cycle) {
        WireStore store = this.queue.storeForCycle(cycle, this.queue.epoch(), false);
        return store != null ? store.file() : null;
    }

    public void onReleased(int cycle, File file) {
        if (this.queue == null || this.retention.disable()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Release Chronicle file: %s, cycle: %d", file, cycle));
        }
        if (this.checkPurge()) {
            this.purge();
        }
    }

    protected boolean checkPurge() {
        if (System.currentTimeMillis() - this.purgedStamp >= (long)this.retention.getRollCycle().length()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Skipping purge already done in within cycle duration: " + this.purgedStamp));
        }
        return false;
    }
}

