/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.tools.command.Command;

public class LagCommand
extends Command {
    protected static final String NAME = "lag";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder().longOpt("name").desc("Log name").hasArg().argName("LOG_NAME").build());
    }

    @Override
    public void run(LogManager manager, CommandLine cmd) throws InterruptedException {
        String name = cmd.getOptionValue("name");
        if (name != null) {
            this.lag(manager, name);
        } else {
            this.lag(manager);
        }
    }

    protected void lag(LogManager manager) {
        System.out.println("# " + manager);
        for (String name : manager.listAll()) {
            this.lag(manager, name);
        }
    }

    protected void lag(LogManager manager, String name) {
        System.out.println("## Log: " + name);
        manager.listConsumerGroups(name).forEach(group -> this.renderLag((String)group, manager.getLag(name, (String)group)));
    }

    protected void renderLag(String group, LogLag lag) {
        System.out.println("### Group: " + group);
        System.out.println("| lag | pos | end | posOffset |\u00a0endOffset\u00a0|\n| --- | ---: | ---: | ---: | ---: |");
        System.out.println(String.format("|%d|%d|%d|%d|%d|", lag.lag(), lag.lower(), lag.upper(), lag.lowerOffset(), lag.upperOffset()));
    }
}

