/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools.command;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.nuxeo.lib.stream.log.LogLag;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.LogTailer;
import org.nuxeo.lib.stream.tools.command.Command;

public class ResetCommand
extends Command {
    protected static final String NAME = "reset";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void updateOptions(Options options) {
        options.addOption(Option.builder((String)"l").longOpt("log-name").desc("Log name").required().hasArg().argName("LOG_NAME").build());
        options.addOption(Option.builder((String)"g").longOpt("group").desc("Consumer group").required().hasArg().argName("GROUP").build());
    }

    @Override
    public boolean run(LogManager manager, CommandLine cmd) throws InterruptedException {
        String name = cmd.getOptionValue("log-name");
        String group = cmd.getOptionValue("group");
        this.reset(manager, group, name);
        return true;
    }

    protected void reset(LogManager manager, String group, String name) {
        LogLag lag = manager.getLag(name, group);
        long pos = lag.lower();
        try (LogTailer tailer = manager.createTailer(group, name);){
            tailer.reset();
        }
        System.out.println(String.format("# Reset log %s, group: %s, from: %s to 0", name, group, pos));
    }
}

