/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.shibboleth.service.ShibbolethAuthenticationService;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.extension.UserMapper;
import org.nuxeo.usermapper.service.UserMapperService;

public class ShibbolethAuthenticationPlugin
implements NuxeoAuthenticationPlugin,
NuxeoAuthenticationPluginLogoutExtension {
    private static final Log log = LogFactory.getLog(ShibbolethAuthenticationPlugin.class);
    public static final String EXTERNAL_MAPPER_PARAM = "mapper";
    public static final String DEFAULT_EXTERNAL_MAPPER = "shibboleth";
    protected UserMapper externalMapper = null;

    protected ShibbolethAuthenticationService getService() {
        return (ShibbolethAuthenticationService)Framework.getService(ShibbolethAuthenticationService.class);
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        if (this.getService() == null) {
            return false;
        }
        String loginURL = this.getService().getLoginURL(httpRequest);
        if (loginURL == null) {
            log.error((Object)"Unable to handle Shibboleth login, no loginURL registered");
            return false;
        }
        try {
            httpResponse.sendRedirect(loginURL);
        }
        catch (IOException e) {
            String errorMessage = String.format("Unable to handle Shibboleth login on %s", loginURL);
            log.error((Object)errorMessage, (Throwable)e);
            return false;
        }
        return true;
    }

    public Boolean handleLogout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.getService() == null) {
            return false;
        }
        String logoutURL = this.getService().getLogoutURL(httpRequest);
        if (logoutURL == null) {
            return false;
        }
        try {
            httpResponse.sendRedirect(logoutURL);
        }
        catch (IOException e) {
            log.error((Object)"Unable to handle Shibboleth logout", (Throwable)e);
            return false;
        }
        return true;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.getService() == null) {
            return null;
        }
        String userId = this.getService().getUserID(httpRequest);
        if (userId == null || "".equals(userId)) {
            return null;
        }
        UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
        if (ums != null && ums.getAvailableMappings().contains(DEFAULT_EXTERNAL_MAPPER)) {
            this.externalMapper = ums.getMapper(DEFAULT_EXTERNAL_MAPPER);
        }
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        Map<String, Object> fieldMap = this.getService().getUserMetadata(userManager.getUserIdField(), httpRequest);
        if (this.externalMapper != null) {
            HashMap<String, Object> nativeObject = new HashMap<String, Object>();
            nativeObject.putAll(fieldMap);
            nativeObject.put("userId", userId);
            this.externalMapper.getOrCreateAndUpdateNuxeoPrincipal(nativeObject);
        } else {
            try (Session userDir = ((DirectoryService)Framework.getService(DirectoryService.class)).open(userManager.getUserDirectoryName());){
                Framework.doPrivileged(() -> {
                    DocumentModel entry = userDir.getEntry(userId);
                    if (entry == null) {
                        userDir.createEntry(fieldMap);
                    } else {
                        entry.setProperties(userManager.getUserSchemaName(), fieldMap);
                        userDir.updateEntry(entry);
                    }
                });
            }
            catch (DirectoryException e) {
                log.error((Object)"Failed to get or create user entry", (Throwable)e);
            }
        }
        return new UserIdentificationInfo(userId, userId);
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return true;
    }

    public void initPlugin(Map<String, String> parameters) {
    }
}

