/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.shibboleth.invitation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.platform.shibboleth.service.ShibbolethAuthenticationService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.shibboleth.invitation.ShibbolethUserInfo;
import org.nuxeo.usermapper.extension.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethUserMapper
implements UserMapper {
    private static final Logger log = LoggerFactory.getLogger(ShibbolethUserMapper.class);
    public static final String DEFAULT_REGISTRATION = "default_registration";
    protected static String userSchemaName = "user";
    protected static String groupSchemaName = "group";
    protected UserManager userManager;

    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject) {
        return this.getOrCreateAndUpdateNuxeoPrincipal(userObject, true, true, null);
    }

    protected UserInvitationService fetchService() {
        return (UserInvitationService)Framework.getService(UserRegistrationService.class);
    }

    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject, boolean createIfNeeded, boolean update, Map<String, Serializable> params) {
        ShibbolethAuthenticationService shiboService = (ShibbolethAuthenticationService)Framework.getService(ShibbolethAuthenticationService.class);
        BiMap metadata = shiboService.getUserMetadata();
        String usernameKey = (String)MoreObjects.firstNonNull((Object)metadata.get((Object)"username"), (Object)"username");
        String lastNameKey = (String)MoreObjects.firstNonNull((Object)metadata.get((Object)"lastName"), (Object)"lastName");
        String firstNameKey = (String)MoreObjects.firstNonNull((Object)metadata.get((Object)"firstName"), (Object)"firstName");
        String emailKey = (String)MoreObjects.firstNonNull((Object)metadata.get((Object)"email"), (Object)"email");
        String companyKey = (String)MoreObjects.firstNonNull((Object)metadata.get((Object)"company"), (Object)"company");
        String passwordKey = (String)MoreObjects.firstNonNull((Object)metadata.get((Object)"password"), (Object)"password");
        String email = (String)((Map)userObject).get(emailKey);
        ShibbolethUserInfo userInfo = new ShibbolethUserInfo((String)((Map)userObject).get(usernameKey), (String)((Map)userObject).get(passwordKey), (String)((Map)userObject).get(firstNameKey), (String)((Map)userObject).get(lastNameKey), (String)((Map)userObject).get(companyKey), email);
        DocumentModel userDoc = null;
        String userName = userInfo.getUserName();
        if (email != null && !email.isEmpty()) {
            userDoc = this.findUser(this.userManager.getUserIdField(), email);
        }
        if (userDoc != null && userName != null) {
            DocumentModel finalUserDoc = userDoc;
            TransactionHelper.runInTransaction(() -> this.updateACP(userName, email, finalUserDoc));
        } else {
            userDoc = (DocumentModel)Framework.doPrivileged(() -> this.userManager.getUserModel(userName));
        }
        if (userDoc == null) {
            userDoc = this.createUser(userInfo);
        } else {
            this.updateUser(userDoc, userInfo);
        }
        String userId = (String)((Object)userDoc.getPropertyValue(this.userManager.getUserIdField()));
        return this.userManager.getPrincipal(userId);
    }

    protected void updateACP(final String userName, final String email, final DocumentModel userDoc) {
        new UnrestrictedSessionRunner(this.getTargetRepositoryName()){

            public void run() {
                NuxeoPrincipal principal = ShibbolethUserMapper.this.userManager.getPrincipal((String)userDoc.getProperty(userSchemaName, "username"));
                ArrayList groups = new ArrayList(principal.getGroups());
                ShibbolethUserMapper.this.userManager.deleteUser(userDoc);
                userDoc.setPropertyValue("user:username", (Serializable)((Object)userName));
                userDoc.setPropertyValue("user:groups", groups);
                ShibbolethUserMapper.this.userManager.createUser(userDoc);
                UserInvitationService userInvitationService = (UserInvitationService)Framework.getService(UserRegistrationService.class);
                DocumentModelListImpl registrationDocuments = new DocumentModelListImpl();
                String query = "SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'validated' AND ecm:mixinType = '" + userInvitationService.getConfiguration(ShibbolethUserMapper.DEFAULT_REGISTRATION).getRequestDocType() + "' AND " + userInvitationService.getConfiguration(ShibbolethUserMapper.DEFAULT_REGISTRATION).getUserInfoUsernameField() + " = '%s' AND ecm:isVersion = 0";
                query = String.format(query, email);
                registrationDocuments.addAll((Collection)this.session.query(query));
                HashMap<String, DocumentModel> targetDocuments = new HashMap<String, DocumentModel>();
                for (DocumentModel doc : registrationDocuments) {
                    String docId = (String)((Object)doc.getPropertyValue("docinfo:documentId"));
                    if (docId == null || targetDocuments.keySet().contains(docId)) continue;
                    targetDocuments.put(docId, this.session.getDocument((DocumentRef)new IdRef(docId)));
                }
                ArrayList targetDocs = new ArrayList(targetDocuments.values());
                for (DocumentModel targetDoc : targetDocs) {
                    for (ACL acl : targetDoc.getACP().getACLs()) {
                        for (ACE oldACE : acl.getACEs()) {
                            if (!oldACE.getUsername().equals(email)) continue;
                            ACE newACE = ACE.builder((String)userName, (String)oldACE.getPermission()).creator(oldACE.getCreator()).begin(oldACE.getBegin()).end(oldACE.getEnd()).build();
                            this.session.replaceACE(targetDoc.getRef(), acl.getName(), oldACE, newACE);
                        }
                    }
                }
            }
        }.runUnrestricted();
    }

    protected DocumentModel createUser(ShibbolethUserInfo userInfo) {
        DocumentModel userDoc;
        try {
            userDoc = this.userManager.getBareUserModel();
            userDoc.setPropertyValue(this.userManager.getUserIdField(), (Serializable)((Object)userInfo.getUserName()));
            userDoc.setPropertyValue(this.userManager.getUserEmailField(), (Serializable)((Object)userInfo.getUserName()));
            Framework.doPrivileged(() -> this.userManager.createUser(userDoc));
        }
        catch (NuxeoException e) {
            String message = "Error while creating user [" + userInfo.getUserName() + "] in UserManager";
            log.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return userDoc;
    }

    public void init(Map<String, String> params) throws Exception {
        this.userManager = (UserManager)Framework.getService(UserManager.class);
        userSchemaName = this.userManager.getUserSchemaName();
        groupSchemaName = this.userManager.getGroupSchemaName();
    }

    private DocumentModel findUser(String field, String userName) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put(field, userName);
        DocumentModelList users = (DocumentModelList)Framework.doPrivileged(() -> this.userManager.searchUsers(query, null));
        if (users.isEmpty()) {
            return null;
        }
        return (DocumentModel)users.get(0);
    }

    private void updateUser(DocumentModel userDoc, ShibbolethUserInfo userInfo) {
        userDoc.setPropertyValue(this.userManager.getUserEmailField(), (Serializable)((Object)userInfo.getEmail()));
        userDoc.setProperty(userSchemaName, "firstName", (Object)userInfo.getFirstName());
        userDoc.setProperty(userSchemaName, "lastName", (Object)userInfo.getLastName());
        userDoc.setProperty(userSchemaName, "password", (Object)userInfo.getPassword());
        userDoc.setProperty(userSchemaName, "company", (Object)userInfo.getCompany());
        Framework.doPrivileged(() -> this.userManager.updateUser(userDoc));
    }

    public Object wrapNuxeoPrincipal(NuxeoPrincipal principal, Object nativePrincipal, Map<String, Serializable> params) {
        throw new UnsupportedOperationException();
    }

    public void release() {
    }

    public String getTargetRepositoryName() {
        return ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
    }
}

