/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.shibboleth.computedgroups;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.computedgroups.AbstractGroupComputer;
import org.nuxeo.ecm.platform.shibboleth.ShibbolethGroupHelper;
import org.nuxeo.ecm.platform.shibboleth.computedgroups.ELGroupComputerHelper;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.api.Framework;

public class ShibbolethGroupComputer
extends AbstractGroupComputer {
    protected String getDirectoryName() {
        return "shibbGroup";
    }

    public List<String> getAllGroupIds() {
        ArrayList<String> groupsId = new ArrayList<String>();
        for (DocumentModel group : this.getAllGroups()) {
            groupsId.add(group.getId());
        }
        return groupsId;
    }

    public List<String> getGroupMembers(String arg0) {
        return null;
    }

    public List<String> getGroupsForUser(NuxeoPrincipalImpl nxPrincipal) {
        ArrayList<String> groupsId = new ArrayList<String>();
        for (DocumentModel group : this.getAllGroups()) {
            String el = (String)((Object)group.getPropertyValue("shibbolethGroup:expressionLanguage"));
            if (!ELGroupComputerHelper.isUserInGroup(nxPrincipal.getModel(), el)) continue;
            groupsId.add(group.getId());
        }
        return groupsId;
    }

    public List<String> getParentsGroupNames(String arg0) {
        return ShibbolethGroupHelper.getParentsGroups(arg0);
    }

    public List<String> getSubGroupsNames(String arg0) {
        return null;
    }

    private DirectoryService getDS() {
        return (DirectoryService)Framework.getService(DirectoryService.class);
    }

    private DocumentModelList getAllGroups() {
        try (Session shibGroupDirectory = this.getDS().open(this.getDirectoryName());){
            DocumentModelList documentModelList = shibGroupDirectory.getEntries();
            return documentModelList;
        }
    }
}

