/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.showcase.content;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.Logs;
import org.nuxeo.ecm.platform.filemanager.service.extension.ExportedZipImporter;
import org.nuxeo.ecm.showcase.content.ShowcaseWriter;
import org.nuxeo.runtime.api.Framework;

public class ShowcaseContentImporter {
    public static final String INITIALIZED_EVENT = "ShowcaseContentImported";
    public static final String DEFAULT_NAME = "default";
    public static final String INITIALIZED_EVENT_FORMAT = "ShowcaseContentImported_%s";
    private static final Log log = LogFactory.getLog(ShowcaseContentImporter.class);
    protected String name;
    protected CoreSession session;

    protected ShowcaseContentImporter(CoreSession session, String name) {
        this.session = session;
        this.name = name;
    }

    public static void run(CoreSession session, String name, Blob blob) throws IOException {
        new ShowcaseContentImporter(session, name).create(blob);
    }

    public DocumentModel create(Blob blob) throws IOException {
        if (this.isImported()) {
            log.debug((Object)String.format("Showcase Content '%s' already imported.", this.name));
            return null;
        }
        DocumentModel doc = this.create(this.session, blob, this.getImportPathRoot(), true);
        this.markImportDone();
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite) throws IOException {
        try (CloseableFile source = content.getCloseableFile(".zip");){
            IdRef resultingRef;
            DocumentModel target;
            try (ZipFile zip = ExportedZipImporter.getArchiveFileIfValid((File)source.getFile());){
                if (zip == null) {
                    DocumentModel documentModel = null;
                    return documentModel;
                }
            }
            boolean importWithIds = false;
            NuxeoArchiveReader reader = new NuxeoArchiveReader(source.getFile());
            ExportedDocument root = reader.read();
            IdRef rootRef = new IdRef(root.getId());
            if (documentManager.exists((DocumentRef)rootRef) && (target = documentManager.getDocument((DocumentRef)rootRef)).getPath().removeLastSegments(1).equals((Object)new Path(path))) {
                importWithIds = true;
            }
            reader.close();
            if (overwrite && importWithIds) {
                resultingRef = rootRef;
            } else {
                String rootName = root.getPath().lastSegment();
                resultingRef = new PathRef(path, rootName);
            }
            ShowcaseWriter writer = new ShowcaseWriter(documentManager, path, 10);
            reader = new NuxeoArchiveReader(source.getFile());
            try {
                DocumentPipeImpl pipe = new DocumentPipeImpl(10);
                pipe.setReader((DocumentReader)reader);
                pipe.setWriter((DocumentWriter)writer);
                pipe.run();
            }
            catch (IOException e) {
                log.warn((Object)e, (Throwable)e);
                DocumentModel documentModel = null;
                if (source != null) {
                    if (var6_6 != null) {
                        try {
                            source.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        source.close();
                    }
                }
                return documentModel;
            }
            finally {
                reader.close();
                writer.close();
            }
            DocumentModel documentModel = documentManager.getDocument((DocumentRef)resultingRef);
            return documentModel;
        }
    }

    protected boolean isImported() {
        return ((Logs)Framework.getService(Logs.class)).getEventsCount(this.getEventName()) > 0L;
    }

    protected void markImportDone() {
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        LogEntry entry = logger.newLogEntry();
        entry.setEventId(this.getEventName());
        entry.setEventDate(Calendar.getInstance().getTime());
        logger.addLogEntries(Collections.singletonList(entry));
    }

    protected String getEventName() {
        if (DEFAULT_NAME.equals(this.name)) {
            return INITIALIZED_EVENT;
        }
        return String.format(INITIALIZED_EVENT_FORMAT, this.name);
    }

    protected String getImportPathRoot() {
        return ((DocumentModel)this.session.query("Select * from Domain").get(0)).getPathAsString();
    }
}

