/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.showcase.content;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.runtime.api.Framework;

public class ShowcaseVideoImportedListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(ShowcaseVideoImportedListener.class);

    public void handleEvent(EventBundle eventBundle) {
        if (eventBundle.containsEventName("documentImported")) {
            eventBundle.forEach(this::handle);
        }
    }

    protected void handle(Event event) {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        if (doc.hasFacet("HasVideoPreview") && !doc.isProxy()) {
            Property origVideoProperty = doc.getProperty("file:content");
            Blob video = (Blob)origVideoProperty.getValue();
            this.updateVideoInfo(doc, video);
            if (video != null) {
                Event trigger = ctx.newEvent("videoChanged");
                EventService eventService = (EventService)Framework.getService(EventService.class);
                eventService.fireEvent(trigger);
            }
        }
    }

    protected void updateVideoInfo(DocumentModel doc, Blob video) {
        try {
            VideoHelper.updateVideoInfo((DocumentModel)doc, (Blob)video);
        }
        catch (NuxeoException e) {
            log.error((Object)String.format("Unable to retrieve video info: %s", e.getMessage()));
            log.debug((Object)e, (Throwable)e);
        }
    }
}

