/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.showcase.content.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.URLBlob;
import org.nuxeo.ecm.showcase.content.ShowcaseContentImporter;
import org.nuxeo.ecm.showcase.content.service.ShowcaseContentDescriptor;
import org.nuxeo.ecm.showcase.content.service.ShowcaseContentService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class ShowcaseContentServiceImpl
extends DefaultComponent
implements ShowcaseContentService {
    private static final Log log = LogFactory.getLog(ShowcaseContentServiceImpl.class);
    public static final String EP_CONTENTS = "contents";
    private ContributionFragmentRegistry<ShowcaseContentDescriptor> registry = new ShowcaseContentDescriptorSimpleContributionRegistry();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_CONTENTS.equals(extensionPoint)) {
            ShowcaseContentDescriptor content = (ShowcaseContentDescriptor)contribution;
            content.computeBlobUrl(contributor);
            this.registry.addContribution((Object)content);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_CONTENTS.equals(extensionPoint)) {
            this.registry.removeContribution((Object)((ShowcaseContentDescriptor)contribution));
        }
    }

    @Override
    public void triggerImporters(CoreSession session) {
        this.getContributions().forEach(c -> {
            URLBlob blob = new URLBlob(c.blobUrl);
            try {
                ShowcaseContentImporter.run(session, c.getName(), (Blob)blob);
            }
            catch (IOException e) {
                log.warn((Object)String.format("Unable to import %s: %s", c.getName(), e), (Throwable)e);
            }
        });
    }

    protected List<ShowcaseContentDescriptor> getContributions() {
        return Arrays.stream(this.registry.getFragments()).map(f -> (ShowcaseContentDescriptor)f.object).filter(c -> c.enabled).collect(Collectors.toList());
    }

    private static class ShowcaseContentDescriptorSimpleContributionRegistry
    extends SimpleContributionRegistry<ShowcaseContentDescriptor> {
        private ShowcaseContentDescriptorSimpleContributionRegistry() {
        }

        public String getContributionId(ShowcaseContentDescriptor contrib) {
            return contrib.getName();
        }
    }
}

