/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.showcase.content;

import java.io.Serializable;
import java.util.Collections;
import org.dom4j.Element;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;

public class ShowcaseWriter
extends DocumentModelWriter {
    public ShowcaseWriter(CoreSession session, String parentPath, int saveInterval) {
        super(session, parentPath, saveInterval);
    }

    protected DocumentModel createDocument(ExportedDocument xdoc, Path toPath) {
        Path parentPath = toPath.removeLastSegments(1);
        DocumentModelImpl doc = new DocumentModelImpl(null, xdoc.getType(), xdoc.getId(), toPath, null, null, (DocumentRef)new PathRef(parentPath.toString()), null, null, null, null);
        Element system = xdoc.getDocument().getRootElement().element("system");
        String lifeCycleState = system.element("lifecycle-state").getText();
        doc.putContextData("ecm:lifeCycleState", (Serializable)((Object)lifeCycleState));
        String lifeCyclePolicy = system.element("lifecycle-policy").getText();
        doc.putContextData("ecm:lifeCyclePolicy", (Serializable)((Object)lifeCyclePolicy));
        doc.putContextData("DocumentValidationService.Forcing", (Serializable)DocumentValidationService.Forcing.TURN_OFF);
        this.loadFacetsInfo((DocumentModel)doc, xdoc.getDocument());
        this.loadSchemas(xdoc, (DocumentModel)doc, xdoc.getDocument());
        if (doc.hasSchema("uid")) {
            doc.putContextData("SKIP_VERSIONING", (Serializable)Boolean.valueOf(true));
        }
        if (doc.hasFacet("Video")) {
            doc.putContextData("forceInformationsGeneration", (Serializable)Boolean.valueOf(true));
        }
        if (doc.hasFacet("Picture")) {
            doc.putContextData("forceViewsGeneration", (Serializable)Boolean.valueOf(true));
        }
        this.session.importDocuments(Collections.singletonList(doc));
        this.loadSystemInfo((DocumentModel)doc, xdoc.getDocument());
        ++this.unsavedDocuments;
        this.saveIfNeeded();
        return doc;
    }
}

