/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.showcase.content;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.video.VideoHelper;
import org.nuxeo.ecm.platform.video.service.VideoInfoWork;
import org.nuxeo.runtime.api.Framework;

public class ShowcaseVideoImportedListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(ShowcaseVideoImportedListener.class);

    public void handleEvent(EventBundle eventBundle) {
        if (eventBundle.containsEventName("documentImported")) {
            eventBundle.forEach(this::handle);
        }
    }

    protected void handle(Event event) {
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel doc = ctx.getSourceDocument();
        if (doc.hasFacet("HasVideoPreview") && !doc.isProxy()) {
            try {
                this.resetProperties(doc);
                doc.putContextData("disableVideoConversionsGenerationListener", (Serializable)Boolean.valueOf(true));
                doc = ctx.getCoreSession().saveDocument(doc);
            }
            catch (IOException e) {
                throw new NuxeoException(String.format("Error while resetting video properties of document %s.", doc), (Throwable)e);
            }
            this.scheduleAsyncProcessing(doc);
        }
    }

    protected void resetProperties(DocumentModel doc) throws IOException {
        log.debug((Object)String.format("Resetting video info, storyboard, previews and conversions of document %s", doc));
        VideoHelper.updateVideoInfo((DocumentModel)doc, null);
        VideoHelper.updateStoryboard((DocumentModel)doc, null);
        VideoHelper.updatePreviews((DocumentModel)doc, null);
        doc.setPropertyValue("vid:transcodedVideos", null);
    }

    protected void scheduleAsyncProcessing(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        VideoInfoWork work = new VideoInfoWork(doc.getRepositoryName(), doc.getId());
        log.debug((Object)String.format("Scheduling work: video info of document %s.", doc));
        workManager.schedule((Work)work, true);
    }
}

