/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.showcase.content.service;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.URLBlob;
import org.nuxeo.ecm.showcase.content.ShowcaseContentImporter;
import org.nuxeo.ecm.showcase.content.service.ShowcaseContentDescriptor;
import org.nuxeo.ecm.showcase.content.service.ShowcaseContentService;
import org.nuxeo.runtime.model.DefaultComponent;

public class ShowcaseContentServiceImpl
extends DefaultComponent
implements ShowcaseContentService {
    private static final Log log = LogFactory.getLog(ShowcaseContentServiceImpl.class);
    public static final String EP_CONTENTS = "contents";

    @Override
    public void triggerImporters(CoreSession session) {
        this.getContributions().forEach(c -> {
            URLBlob blob = new URLBlob(c.getBlobUrl());
            try {
                ShowcaseContentImporter.run(session, c.getName(), (Blob)blob);
            }
            catch (IOException e) {
                log.warn((Object)String.format("Unable to import %s: %s", c.getName(), e), (Throwable)e);
            }
        });
    }

    protected List<ShowcaseContentDescriptor> getContributions() {
        return this.getDescriptors(EP_CONTENTS).stream().filter(ShowcaseContentDescriptor::isEnabled).toList();
    }
}

