/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.wiki.rendering;

import java.util.regex.Matcher;
import org.nuxeo.ecm.platform.rendering.wiki.WikiFilter;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.webengine.sites.utils.SiteConstants;

public class WikiSitesPageLinkResolver
implements WikiFilter {
    public String apply(String content) {
        Matcher m = SiteConstants.PAGE_LINK_PATTERN.matcher(content);
        StringBuffer sb = new StringBuffer();
        if (!m.find()) {
            return content;
        }
        do {
            String s = m.group();
            String link = this.buildLinks(s);
            m.appendReplacement(sb, link);
        } while (m.find());
        m.appendTail(sb);
        return sb.toString();
    }

    protected String buildLinks(String pageName) {
        WebContext ctx = WebEngine.getActiveContext();
        Resource resource = ctx.getTargetObject();
        StringBuilder links = new StringBuilder();
        StringBuffer relativePath = new StringBuffer();
        if (pageName.startsWith(".")) {
            String basePath = ctx.getModulePath();
            String[] segments = pageName.substring(1).split("\\.");
            Resource parentResource = resource.getPrevious();
            while (!parentResource.isInstanceOf("site")) {
                parentResource = parentResource.getPrevious();
            }
            relativePath.append("/").append(parentResource.getName());
            for (String segment : segments) {
                links.append(".");
                relativePath.append("/").append(segment);
                links.append(this.buildLink(basePath, relativePath, segment));
            }
        } else {
            String[] segments;
            String basePath = resource.getPath();
            for (String segment : segments = pageName.split("\\.")) {
                relativePath.append("/").append(segment);
                links.append(this.buildLink(basePath, relativePath, segment));
                links.append(".");
            }
            links.deleteCharAt(links.length() - 1);
        }
        return links.toString();
    }

    protected String buildLink(String basePath, StringBuffer relativePath, String str) {
        return String.format("<a href=\"%s\">%s</a>", basePath + relativePath, str);
    }
}

