/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisServiceWrapper<T extends CmisService>
implements CmisService {
    public static final BigInteger MINUS_ONE = BigInteger.valueOf(-1L);
    private static final Logger LOG = LoggerFactory.getLogger(CmisServiceWrapper.class);
    private BigInteger defaultTypesMaxItems = null;
    private BigInteger defaultTypesDepth = MINUS_ONE;
    private BigInteger defaultMaxItems = null;
    private BigInteger defaultDepth = MINUS_ONE;
    private final T service;

    public CmisServiceWrapper(T service, BigInteger defaultTypesMaxItems, BigInteger defaultTypesDepth, BigInteger defaultMaxItems, BigInteger defaultDepth) {
        if (service == null) {
            throw new IllegalArgumentException("Service must be set!");
        }
        this.service = service;
        this.setDefaultTypesMaxItems(defaultTypesMaxItems);
        this.setDefaultTypesDepth(defaultTypesDepth);
        this.setDefaultMaxItems(defaultMaxItems);
        this.setDefaultDepth(defaultDepth);
    }

    protected void setDefaultTypesMaxItems(BigInteger defaultTypesMaxItems) {
        this.defaultTypesMaxItems = defaultTypesMaxItems;
    }

    protected void setDefaultTypesDepth(BigInteger defaultTypesDepth) {
        this.defaultTypesDepth = defaultTypesDepth;
    }

    protected void setDefaultMaxItems(BigInteger defaultMaxItems) {
        this.defaultMaxItems = defaultMaxItems;
    }

    protected void setDefaultDepth(BigInteger defaultDepth) {
        this.defaultDepth = defaultDepth;
    }

    protected CmisBaseException createCmisException(Exception e) {
        if (e == null) {
            return new CmisRuntimeException("Unknown exception!");
        }
        if (e instanceof CmisBaseException) {
            return (CmisBaseException)e;
        }
        LOG.warn(e.toString(), (Throwable)e);
        return new CmisRuntimeException(e.getMessage(), (Throwable)e);
    }

    protected void checkId(String name, String id) {
        if (id == null) {
            throw new CmisInvalidArgumentException(name + " must be set!");
        }
        if (id.length() == 0) {
            throw new CmisInvalidArgumentException(name + " must not be empty!");
        }
    }

    protected void checkIds(String name, String ... ids) {
        for (String id : ids) {
            if (id == null || id.length() <= 0) continue;
            return;
        }
        throw new CmisInvalidArgumentException(name + " must be set!");
    }

    protected void checkHolderId(String name, Holder<String> holder) {
        if (holder == null) {
            throw new CmisInvalidArgumentException(name + " must be set!");
        }
        this.checkId(name, (String)holder.getValue());
    }

    protected void checkRepositoryId(String repositoryId) {
        this.checkId("Repository Id", repositoryId);
    }

    protected void checkPath(String name, String path) {
        if (path == null) {
            throw new CmisInvalidArgumentException(name + " must be set!");
        }
        if (path.length() == 0) {
            throw new CmisInvalidArgumentException(name + " must not be empty!");
        }
        if (path.charAt(0) != '/') {
            throw new CmisInvalidArgumentException(name + " must start with '/'!");
        }
    }

    protected void checkProperties(Properties properties) {
        if (properties == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
    }

    protected void checkProperty(Properties properties, String propertyId, Class<?> clazz) {
        if (properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " must be set!");
        }
        PropertyData property = (PropertyData)properties.getProperties().get(propertyId);
        if (property == null) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " must be set!");
        }
        Object value = property.getFirstValue();
        if (value == null) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " must have a value!");
        }
        if (!clazz.isAssignableFrom(value.getClass())) {
            throw new CmisInvalidArgumentException("Property " + propertyId + " has the wrong type!");
        }
    }

    protected void checkContentStream(ContentStream content) {
        if (content == null) {
            throw new CmisInvalidArgumentException("Content must be set!");
        }
    }

    protected void checkQueryStatement(String statement) {
        if (statement == null) {
            throw new CmisInvalidArgumentException("Statement must be set!");
        }
        if (statement.length() == 0) {
            throw new CmisInvalidArgumentException("Statement must not be empty!");
        }
    }

    protected void checkTypeDefinition(TypeDefinition typeDef) {
        if (typeDef == null) {
            throw new CmisInvalidArgumentException("Type definition must be set!");
        }
    }

    protected void checkList(String name, List<?> list) {
        if (list == null) {
            throw new CmisInvalidArgumentException(name + " must be set!");
        }
        if (list.isEmpty()) {
            throw new CmisInvalidArgumentException(name + " must not be empty!");
        }
    }

    protected Boolean getDefaultTrue(Boolean value) {
        if (value == null) {
            return Boolean.TRUE;
        }
        return value;
    }

    protected Boolean getDefaultFalse(Boolean value) {
        if (value == null) {
            return Boolean.FALSE;
        }
        return value;
    }

    protected IncludeRelationships getDefault(IncludeRelationships value) {
        if (value == null) {
            return IncludeRelationships.NONE;
        }
        return value;
    }

    protected VersioningState getDefault(VersioningState value) {
        if (value == null) {
            return VersioningState.MAJOR;
        }
        return value;
    }

    protected UnfileObject getDefault(UnfileObject value) {
        if (value == null) {
            return UnfileObject.DELETE;
        }
        return value;
    }

    protected AclPropagation getDefault(AclPropagation value) {
        if (value == null) {
            return AclPropagation.REPOSITORYDETERMINED;
        }
        return value;
    }

    protected RelationshipDirection getDefault(RelationshipDirection value) {
        if (value == null) {
            return RelationshipDirection.SOURCE;
        }
        return value;
    }

    protected String getDefaultRenditionFilter(String value) {
        if (value == null || value.length() == 0) {
            return "cmis:none";
        }
        return value;
    }

    protected BigInteger getTypesMaxItems(BigInteger maxItems) {
        if (maxItems == null) {
            return this.defaultTypesMaxItems;
        }
        if (maxItems.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException("maxItems must not be negative!");
        }
        return maxItems;
    }

    protected BigInteger getTypesDepth(BigInteger depth) {
        if (depth == null) {
            return this.defaultTypesDepth;
        }
        if (depth.compareTo(BigInteger.ZERO) == 0) {
            throw new CmisInvalidArgumentException("depth must not be 0!");
        }
        if (depth.compareTo(MINUS_ONE) == -1) {
            throw new CmisInvalidArgumentException("depth must not be <-1!");
        }
        return depth;
    }

    protected BigInteger getMaxItems(BigInteger maxItems) {
        if (maxItems == null) {
            return this.defaultMaxItems;
        }
        if (maxItems.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException("maxItems must not be negative!");
        }
        return maxItems;
    }

    protected BigInteger getSkipCount(BigInteger skipCount) {
        if (skipCount == null) {
            return BigInteger.ZERO;
        }
        if (skipCount.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException("skipCount must not be negative!");
        }
        return skipCount;
    }

    protected BigInteger getDepth(BigInteger depth) {
        if (depth == null) {
            return this.defaultDepth;
        }
        if (depth.compareTo(BigInteger.ZERO) == 0) {
            throw new CmisInvalidArgumentException("depth must not be 0!");
        }
        if (depth.compareTo(MINUS_ONE) == -1) {
            throw new CmisInvalidArgumentException("depth must not be <-1!");
        }
        return depth;
    }

    protected void checkNullOrPositive(String name, BigInteger value) {
        if (value == null) {
            return;
        }
        if (value.compareTo(BigInteger.ZERO) == -1) {
            throw new CmisInvalidArgumentException(name + " must not be negative!");
        }
    }

    public T getWrappedService() {
        return this.service;
    }

    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        return this.service.getObjectInfo(repositoryId, objectId);
    }

    public void close() {
        this.service.close();
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        try {
            return this.service.getRepositoryInfo(repositoryId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        try {
            return this.service.getRepositoryInfos(extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includePropertyDefinitions = this.getDefaultFalse(includePropertyDefinitions);
        maxItems = this.getTypesMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.service.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Type Id", typeId);
        try {
            return this.service.getTypeDefinition(repositoryId, typeId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includePropertyDefinitions = this.getDefaultFalse(includePropertyDefinitions);
        depth = this.getTypesDepth(depth);
        try {
            return this.service.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkTypeDefinition(type);
        try {
            return this.service.createType(repositoryId, type, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkTypeDefinition(type);
        try {
            return this.service.updateType(repositoryId, type, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Type Id", typeId);
        try {
            this.service.deleteType(repositoryId, typeId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.service.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePathSegment = this.getDefaultFalse(includePathSegment);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.service.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        depth = this.getDepth(depth);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePathSegment = this.getDefaultFalse(includePathSegment);
        try {
            return this.service.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        try {
            return this.service.getFolderParent(repositoryId, folderId, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        depth = this.getDepth(depth);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePathSegment = this.getDefaultFalse(includePathSegment);
        try {
            return this.service.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includeRelativePathSegment = this.getDefaultFalse(includeRelativePathSegment);
        try {
            return this.service.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        versioningState = this.getDefault(versioningState);
        try {
            return this.service.create(repositoryId, properties, folderId, contentStream, versioningState, policies, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        versioningState = this.getDefault(versioningState);
        try {
            return this.service.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Source Id", sourceId);
        versioningState = this.getDefault(versioningState);
        try {
            return this.service.createDocumentFromSource(repositoryId, sourceId, properties, folderId, versioningState, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        this.checkId("Folder Id", folderId);
        try {
            return this.service.createFolder(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.service.createPolicy(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.service.createItem(repositoryId, properties, folderId, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkProperties(properties);
        this.checkProperty(properties, "cmis:objectTypeId", String.class);
        try {
            return this.service.createRelationship(repositoryId, properties, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        try {
            this.service.deleteContentStream(repositoryId, objectId, changeToken, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        allVersions = this.getDefaultTrue(allVersions);
        try {
            this.service.deleteObject(repositoryId, objectId, allVersions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        allVersions = this.getDefaultTrue(allVersions);
        try {
            this.service.deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Folder Id", folderId);
        allVersions = this.getDefaultTrue(allVersions);
        unfileObjects = this.getDefault(unfileObjects);
        continueOnFailure = this.getDefaultFalse(continueOnFailure);
        try {
            return this.service.deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            return this.service.getAllowableActions(repositoryId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        this.checkNullOrPositive("Offset", offset);
        this.checkNullOrPositive("Length", length);
        try {
            return this.service.getContentStream(repositoryId, objectId, streamId, offset, length, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        try {
            return this.service.getObject(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkPath("Path", path);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        try {
            return this.service.getObjectByPath(repositoryId, path, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            return this.service.getProperties(repositoryId, objectId, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        this.checkId("Target Folder Id", targetFolderId);
        try {
            this.service.moveObject(repositoryId, objectId, targetFolderId, sourceFolderId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        overwriteFlag = this.getDefaultTrue(overwriteFlag);
        this.checkContentStream(contentStream);
        try {
            this.service.setContentStream(repositoryId, objectId, overwriteFlag, changeToken, contentStream, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        this.checkContentStream(contentStream);
        try {
            this.service.appendContentStream(repositoryId, objectId, changeToken, contentStream, isLastChunk, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        this.checkProperties(properties);
        try {
            this.service.updateProperties(repositoryId, objectId, changeToken, properties, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkList("Object Id list", objectIdAndChangeToken);
        this.checkProperties(properties);
        try {
            return this.service.bulkUpdateProperties(repositoryId, objectIdAndChangeToken, properties, addSecondaryTypeIds, removeSecondaryTypeIds, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            this.service.cancelCheckOut(repositoryId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        major = this.getDefaultTrue(major);
        try {
            this.service.checkIn(repositoryId, objectId, major, properties, contentStream, checkinComment, policies, addAces, removeAces, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        this.checkRepositoryId(repositoryId);
        this.checkHolderId("Object Id", objectId);
        try {
            this.service.checkOut(repositoryId, objectId, extension, contentCopied);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkIds("Version Series Id", objectId, versionSeriesId);
        major = this.getDefaultFalse(major);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        try {
            return this.service.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkIds("Version Series Id", objectId, versionSeriesId);
        major = this.getDefaultFalse(major);
        try {
            return this.service.getPropertiesOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkIds("Version Series Id", objectId, versionSeriesId);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        try {
            return this.service.getAllVersions(repositoryId, objectId, versionSeriesId, filter, includeAllowableActions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        includeProperties = this.getDefaultFalse(includeProperties);
        includePolicyIds = this.getDefaultFalse(includePolicyIds);
        includeAcl = this.getDefaultFalse(includeAcl);
        maxItems = this.getMaxItems(maxItems);
        try {
            return this.service.getContentChanges(repositoryId, changeLogToken, includeProperties, filter, includePolicyIds, includeAcl, maxItems, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkQueryStatement(statement);
        searchAllVersions = this.getDefaultFalse(searchAllVersions);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        includeRelationships = this.getDefault(includeRelationships);
        renditionFilter = this.getDefaultRenditionFilter(renditionFilter);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.service.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        this.checkId("Folder Id", folderId);
        allVersions = this.getDefaultTrue(allVersions);
        try {
            this.service.addObjectToFolder(repositoryId, objectId, folderId, allVersions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            this.service.removeObjectFromFolder(repositoryId, objectId, folderId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        includeSubRelationshipTypes = this.getDefaultFalse(includeSubRelationshipTypes);
        relationshipDirection = this.getDefault(relationshipDirection);
        includeAllowableActions = this.getDefaultFalse(includeAllowableActions);
        maxItems = this.getMaxItems(maxItems);
        skipCount = this.getSkipCount(skipCount);
        try {
            return this.service.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes, relationshipDirection, typeId, filter, includeAllowableActions, maxItems, skipCount, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        aclPropagation = this.getDefault(aclPropagation);
        try {
            return this.service.applyAcl(repositoryId, objectId, aces, aclPropagation);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        aclPropagation = this.getDefault(aclPropagation);
        try {
            return this.service.applyAcl(repositoryId, objectId, addAces, removeAces, aclPropagation, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        onlyBasicPermissions = this.getDefaultTrue(onlyBasicPermissions);
        try {
            return this.service.getAcl(repositoryId, objectId, onlyBasicPermissions, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Policy Id", policyId);
        this.checkId("Object Id", objectId);
        try {
            this.service.applyPolicy(repositoryId, policyId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Object Id", objectId);
        try {
            return this.service.getAppliedPolicies(repositoryId, objectId, filter, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        this.checkRepositoryId(repositoryId);
        this.checkId("Policy Id", policyId);
        this.checkId("Object Id", objectId);
        try {
            this.service.removePolicy(repositoryId, policyId, objectId, extension);
        }
        catch (Exception e) {
            throw this.createCmisException(e);
        }
    }
}

