/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites;

import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.webengine.sites.Site;
import org.nuxeo.webengine.sites.SiteDocumentTree;

@WebAdapter(name="json", type="JsonTreeAdapter", facets={"Site"})
public class JsonAdapter
extends DefaultAdapter {
    public static final String NAVIGATOR_TREE = "navigatorTree";
    public static final String ROOT_DOCUMENT = "siteName";

    @GET
    public Response doGet(@QueryParam(value="root") String root) {
        WebContext ctx = WebEngine.getActiveContext();
        Resource o = ctx.getTargetObject();
        DocumentModel rootDoc = null;
        DocumentModel currentDoc = null;
        if (o instanceof Site) {
            Site site = (Site)o;
            currentDoc = rootDoc = site.getDocument();
        } else if (o instanceof DocumentObject) {
            DocumentObject docObj = (DocumentObject)o;
            currentDoc = docObj.getDocument();
            rootDoc = JsonAdapter.getTreeRoot(currentDoc);
        }
        if (rootDoc != null) {
            DocumentModel doc = (DocumentModel)ctx.getUserSession().get((Object)ROOT_DOCUMENT);
            if (doc == null || !doc.equals(rootDoc)) {
                ctx.getUserSession().put((Object)ROOT_DOCUMENT, (Object)rootDoc);
            }
            SiteDocumentTree tree = new SiteDocumentTree(ctx, rootDoc);
            String result = "";
            if (root == null || "source".equals(root)) {
                Path relPath = JsonAdapter.getRelativePath(rootDoc, currentDoc);
                tree.enter(ctx, relPath.toString());
                result = tree.getTreeAsJSONArray(ctx);
            } else {
                result = tree.enter(ctx, root);
            }
            return Response.ok().entity((Object)result).build();
        }
        return null;
    }

    public static Path getRelativePath(DocumentModel rootDoc, DocumentModel doc) {
        Path rootPath = rootDoc.getPath();
        Path docPath = doc.getPath();
        int n = rootPath.segmentCount();
        if (docPath.matchingFirstSegments(rootPath) == n) {
            return docPath.removeFirstSegments(n);
        }
        return null;
    }

    protected static DocumentModel getTreeRoot(DocumentModel doc) {
        if (doc != null) {
            CoreSession session = doc.getCoreSession();
            DocumentModel parent = doc;
            while (parent != null) {
                if (parent.hasFacet("WebView")) {
                    return parent;
                }
                try {
                    parent = session.getDocument(parent.getParentRef());
                }
                catch (ClientException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

