/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStream;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartParser {
    public static final String MULTIPART = "multipart/";
    private static final String CHARSET_FIELD = "_charset_";
    private static final int MAX_FIELD_BYTES = 0xA00000;
    private static final int BUFFER_SIZE = 131072;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final HttpServletRequest request;
    private final ThresholdOutputStreamFactory streamFactory;
    private final InputStream requestStream;
    private byte[] boundary;
    private int[] badCharacters;
    private int[] goodSuffixes;
    private byte[] buffer;
    private byte[] buffer2;
    private int bufferPosition;
    private int bufferCount;
    private boolean eof;
    private int fieldBytes;
    private boolean hasContent;
    private Map<String, String> headers;
    private String filename;
    private String contentType;
    private BigInteger contentSize;
    private InputStream contentStream;
    private Map<String, String[]> fields;
    private Map<String, byte[][]> rawFields;
    private String charset = "ISO-8859-1";

    public MultipartParser(HttpServletRequest request, ThresholdOutputStreamFactory streamFactory) throws IOException {
        this.request = request;
        this.streamFactory = streamFactory;
        this.requestStream = request.getInputStream();
        this.extractBoundary();
        this.buffer = new byte[131072 + this.boundary.length];
        this.buffer2 = new byte[this.buffer.length];
        this.bufferPosition = 0;
        this.bufferCount = 0;
        this.eof = false;
        this.hasContent = false;
        this.fieldBytes = 0;
        this.fields = new HashMap<String, String[]>();
        this.rawFields = new HashMap<String, byte[][]>();
        this.skipPreamble();
    }

    private void addField(String name, String value) {
        String[] values = this.fields.get(name);
        if (values == null) {
            this.fields.put(name, new String[]{value});
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            this.fields.put(name, newValues);
        }
    }

    private void addRawField(String name, byte[] value) {
        byte[][] values = this.rawFields.get(name);
        if (values == null) {
            byte[][] newValue = new byte[][]{value};
            this.rawFields.put(name, newValue);
        } else {
            byte[][] newValues = new byte[values.length + 1][];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            this.rawFields.put(name, newValues);
        }
    }

    private void extractBoundary() {
        int j;
        String requestContentType = this.request.getContentType();
        byte[] extractedBoundary = MimeHelper.getBoundaryFromMultiPart((String)requestContentType);
        if (extractedBoundary == null) {
            throw new CmisInvalidArgumentException("Invalid multipart request!");
        }
        this.boundary = new byte[BOUNDARY_PREFIX.length + extractedBoundary.length];
        System.arraycopy(BOUNDARY_PREFIX, 0, this.boundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(extractedBoundary, 0, this.boundary, BOUNDARY_PREFIX.length, extractedBoundary.length);
        int m = this.boundary.length;
        this.badCharacters = new int[256];
        Arrays.fill(this.badCharacters, -1);
        for (int j2 = 0; j2 < m; ++j2) {
            this.badCharacters[this.boundary[j2] & 0xFF] = j2;
        }
        int[] f = new int[m + 1];
        this.goodSuffixes = new int[m + 1];
        int i = m;
        f[i] = j = m + 1;
        while (i > 0) {
            while (j <= m && this.boundary[i - 1] != this.boundary[j - 1]) {
                if (this.goodSuffixes[j] == 0) {
                    this.goodSuffixes[j] = j - i;
                }
                j = f[j];
            }
            f[--i] = --j;
        }
        j = f[0];
        for (i = 0; i <= m; ++i) {
            if (this.goodSuffixes[i] == 0) {
                this.goodSuffixes[i] = j;
            }
            if (i != j) continue;
            j = f[j];
        }
    }

    private int findBoundary() {
        int j;
        if (this.bufferCount < this.boundary.length) {
            if (this.eof) {
                throw new CmisInvalidArgumentException("Unexpected end of stream!");
            }
            return -1;
        }
        int m = this.boundary.length;
        for (int i = 0; i <= this.bufferCount - m; i += Math.max(this.goodSuffixes[j + 1], j - this.badCharacters[this.buffer[i + j] & 0xFF])) {
            for (j = m - 1; j >= 0 && this.boundary[j] == this.buffer[i + j]; --j) {
            }
            if (j >= 0) continue;
            return i;
        }
        return -1;
    }

    private void readBuffer() throws IOException {
        if (this.bufferPosition < this.bufferCount) {
            System.arraycopy(this.buffer, this.bufferPosition, this.buffer2, 0, this.bufferCount - this.bufferPosition);
            this.bufferCount -= this.bufferPosition;
            byte[] tmpBuffer = this.buffer2;
            this.buffer2 = this.buffer;
            this.buffer = tmpBuffer;
        } else {
            this.bufferCount = 0;
        }
        this.bufferPosition = 0;
        if (this.eof) {
            return;
        }
        do {
            int r;
            if ((r = this.requestStream.read(this.buffer, this.bufferCount, this.buffer.length - this.bufferCount)) == -1) {
                this.eof = true;
                break;
            }
            this.bufferCount += r;
        } while (this.buffer.length != this.bufferCount);
    }

    private int nextByte() throws IOException {
        if (this.bufferCount == 0) {
            if (this.eof) {
                return -1;
            }
            this.readBuffer();
            return this.nextByte();
        }
        if (this.bufferCount > this.bufferPosition) {
            return this.buffer[this.bufferPosition++] & 0xFF;
        }
        this.readBuffer();
        return this.nextByte();
    }

    private String readLine() throws IOException {
        int r;
        StringBuilder sb = new StringBuilder();
        while ((r = this.nextByte()) > -1) {
            if (r == 13) {
                if (this.nextByte() == 10) break;
                throw new CmisInvalidArgumentException("Invalid multipart request!");
            }
            sb.append((char)r);
        }
        return sb.toString();
    }

    private void readHeaders() throws IOException {
        int b = this.nextByte();
        if (b == -1) {
            throw new CmisInvalidArgumentException("Unexpected end of stream!");
        }
        if (b == 45) {
            b = this.nextByte();
            if (b == 45) {
                this.headers = null;
                return;
            }
        } else if (b == 13 && (b = this.nextByte()) == 10) {
            this.parseHeaders();
            return;
        }
        throw new CmisInvalidArgumentException("Invalid multipart request!");
    }

    private void parseHeaders() throws IOException {
        String line;
        this.headers = new HashMap<String, String>();
        while ((line = this.readLine()).length() != 0) {
            int x = line.indexOf(58);
            if (x <= 0) continue;
            this.headers.put(line.substring(0, x).toLowerCase(Locale.ENGLISH).trim(), line.substring(x + 1).trim());
        }
    }

    private byte[] readBodyBytes() throws IOException {
        this.readBuffer();
        int boundaryPosition = this.findBoundary();
        if (boundaryPosition > -1) {
            int len = boundaryPosition - this.bufferPosition;
            this.addFieldBytes(len);
            byte[] body = new byte[len];
            System.arraycopy(this.buffer, this.bufferPosition, body, 0, len);
            this.bufferPosition = boundaryPosition + this.boundary.length;
            return body;
        }
        int len = Math.min(131072, this.bufferCount) - this.bufferPosition;
        this.addFieldBytes(len);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(len + 32);
        bos.write(this.buffer, this.bufferPosition, len);
        this.bufferPosition += len;
        while (true) {
            this.readBuffer();
            boundaryPosition = this.findBoundary();
            if (boundaryPosition > -1) break;
            len = Math.min(131072, this.bufferCount) - this.bufferPosition;
            this.addFieldBytes(len);
            bos.write(this.buffer, this.bufferPosition, len);
            this.bufferPosition += len;
        }
        len = boundaryPosition - this.bufferPosition;
        this.addFieldBytes(len);
        bos.write(this.buffer, this.bufferPosition, len);
        this.bufferPosition = boundaryPosition + this.boundary.length;
        return bos.toByteArray();
    }

    private void addFieldBytes(int len) {
        this.fieldBytes += len;
        if (this.fieldBytes > 0xA00000) {
            throw new CmisInvalidArgumentException("Limit exceeded!");
        }
    }

    private void readBodyAsStream() throws IOException {
        ThresholdOutputStream stream = this.streamFactory.newOutputStream();
        try {
            int boundaryPosition;
            while (true) {
                this.readBuffer();
                boundaryPosition = this.findBoundary();
                if (boundaryPosition > -1) break;
                int len = Math.min(131072, this.bufferCount) - this.bufferPosition;
                stream.write(this.buffer, this.bufferPosition, len);
                this.bufferPosition += len;
            }
            stream.write(this.buffer, this.bufferPosition, boundaryPosition - this.bufferPosition);
            this.bufferPosition = boundaryPosition + this.boundary.length;
            stream.close();
            this.contentSize = BigInteger.valueOf(stream.getSize());
            this.contentStream = stream.getInputStream();
        }
        catch (IOException e) {
            stream.destroy();
            throw e;
        }
    }

    private void readBody() throws IOException {
        String contentDisposition = this.headers.get("content-disposition");
        if (contentDisposition == null) {
            throw new CmisInvalidArgumentException("Invalid multipart request!");
        }
        HashMap params = new HashMap();
        MimeHelper.decodeContentDisposition((String)contentDisposition, params);
        boolean isContent = params.containsKey("filename");
        if (isContent) {
            if (this.hasContent) {
                throw new CmisInvalidArgumentException("Only one content expected!");
            }
            this.hasContent = true;
            this.filename = (String)params.get("filename");
            if (this.filename != null) {
                int pathsep = this.filename.lastIndexOf(47);
                if (pathsep > -1) {
                    this.filename = this.filename.substring(pathsep + 1);
                }
                if ((pathsep = this.filename.lastIndexOf(92)) > -1) {
                    this.filename = this.filename.substring(pathsep + 1);
                }
                this.filename = this.filename.trim();
            }
            this.contentType = this.headers.get("content-type");
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            }
            this.readBodyAsStream();
        } else {
            String fieldCharset;
            String name = (String)params.get("name");
            byte[] rawValue = this.readBodyBytes();
            if (CHARSET_FIELD.equalsIgnoreCase(name)) {
                this.charset = new String(rawValue, "ISO-8859-1");
                return;
            }
            String fieldContentType = this.headers.get("content-type");
            if (fieldContentType != null && (fieldCharset = MimeHelper.getCharsetFromContentType((String)fieldContentType)) != null) {
                this.addField(name, new String(rawValue, fieldCharset));
                return;
            }
            this.addRawField(name, rawValue);
        }
    }

    private void skipPreamble() throws IOException {
        int boundaryPosition;
        this.readBuffer();
        if (this.bufferCount < this.boundary.length - 2) {
            throw new CmisInvalidArgumentException("Invalid multipart request!");
        }
        for (int i = 2; i < this.boundary.length && this.boundary[i] == this.buffer[i - 2]; ++i) {
            if (i != this.boundary.length - 1) continue;
            this.bufferPosition = this.boundary.length - 2;
            this.readBuffer();
            return;
        }
        while (true) {
            if ((boundaryPosition = this.findBoundary()) > -1) break;
            this.bufferPosition = 131073;
            this.readBuffer();
        }
        this.bufferPosition = boundaryPosition + this.boundary.length;
        this.readBuffer();
    }

    private void skipEpilogue() {
        try {
            int b;
            int count = 0;
            byte[] tmpBuf = new byte[4096];
            while ((b = this.requestStream.read(tmpBuf)) > -1 && (count += b) < 0x100000) {
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean readNext() throws IOException {
        try {
            this.readHeaders();
            if (this.headers == null) {
                this.skipEpilogue();
                return false;
            }
            this.readBody();
            return true;
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Closeable)this.contentStream);
            this.skipEpilogue();
            throw e;
        }
    }

    public void parse() throws IOException {
        try {
            while (this.readNext()) {
            }
            for (Map.Entry<String, byte[][]> e : this.rawFields.entrySet()) {
                String[] otherValues = this.fields.get(e.getKey());
                int index = otherValues != null ? otherValues.length : 0;
                String[] values = new String[e.getValue().length + index];
                if (otherValues != null) {
                    System.arraycopy(otherValues, 0, values, 0, otherValues.length);
                }
                for (byte[] rawValue : e.getValue()) {
                    values[index++] = new String(rawValue, this.charset);
                }
                this.fields.put(e.getKey(), values);
            }
        }
        catch (Exception e) {
            if (this.contentStream != null) {
                IOUtils.closeQuietly((Closeable)this.contentStream);
            }
            this.skipEpilogue();
            this.fields = null;
            if (e instanceof UnsupportedEncodingException) {
                throw new CmisInvalidArgumentException("Encoding not supported!", (Throwable)e);
            }
            if (e instanceof CmisBaseException) {
                throw (CmisBaseException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.rawFields = null;
        }
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BigInteger getSize() {
        return this.contentSize;
    }

    public InputStream getStream() {
        return this.contentStream;
    }

    public Map<String, String[]> getFields() {
        return this.fields;
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }
}

