/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryStringHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> parameters = new HashMap<String, String[]>();

    public QueryStringHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.parseFormData(request.getQueryString());
    }

    protected final void parseFormData(String queryString) throws IOException {
        String[] nameValuePairs;
        if (queryString == null || queryString.length() < 3) {
            return;
        }
        for (String nameValuePair : nameValuePairs = queryString.split("&")) {
            String name;
            int x = nameValuePair.indexOf(61);
            if (x > 0) {
                name = IOUtils.decodeURL((String)nameValuePair.substring(0, x));
                String value = x == nameValuePair.length() - 1 ? "" : IOUtils.decodeURL((String)nameValuePair.substring(x + 1));
                this.addParameter(name, value);
                continue;
            }
            name = IOUtils.decodeURL((String)nameValuePair);
            this.addParameter(name, (String)null);
        }
    }

    protected final void addParameter(String name, String value) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            this.parameters.put(name, new String[]{value});
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            this.parameters.put(name, newValues);
        }
    }

    protected final void addParameter(String name, String[] additionalValues) {
        String[] values = this.parameters.get(name);
        if (values == null) {
            this.parameters.put(name, additionalValues);
        } else {
            String[] newValues = new String[values.length + additionalValues.length];
            System.arraycopy(values, 0, newValues, 0, values.length);
            System.arraycopy(additionalValues, 0, newValues, values.length, additionalValues.length);
            this.parameters.put(name, newValues);
        }
    }

    public final String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public final Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public final Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public final String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }
}

