/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import com.sun.xml.ws.developer.StreamingAttachment;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MTOM
@StreamingAttachment(parseEagerly=false, memoryThreshold=0x4B4000L)
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.VersioningServicePort")
public class VersioningService
extends AbstractService
implements VersioningServicePort {
    @Resource
    public WebServiceContext wsContext;

    public void cancelCheckOut(String repositoryId, String objectId, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            ExtensionsData extData = WSConverter.convertExtensionHolder(extension);
            service.cancelCheckOut(repositoryId, objectId, extData);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, CmisPropertiesType properties, CmisContentStreamType contentStream, String checkinComment, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = WSConverter.convertHolder(objectId);
            ExtensionsData extData = WSConverter.convertExtensionHolder(extension);
            service.checkIn(repositoryId, objectIdHolder, major, WSConverter.convert((CmisPropertiesType)properties), WSConverter.convert((CmisContentStreamType)contentStream, (boolean)false), checkinComment, policies, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void checkOut(String repositoryId, Holder<String> objectId, Holder<CmisExtensionType> extension, Holder<Boolean> contentCopied) throws CmisException {
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder = WSConverter.convertHolder(objectId);
            org.apache.chemistry.opencmis.commons.spi.Holder contentCopiedHolder = new org.apache.chemistry.opencmis.commons.spi.Holder();
            ExtensionsData extData = WSConverter.convertExtensionHolder(extension);
            service.checkOut(repositoryId, objectIdHolder, extData, contentCopiedHolder);
            if (contentCopied != null) {
                contentCopied.value = contentCopiedHolder.getValue();
            }
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public List<CmisObjectType> getAllVersions(String repositoryId, String versionSeriesId, String filter, Boolean includeAllowableActions, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisObjectType> arrayList;
        List versions;
        CmisVersion cmisVersion;
        CmisService service;
        block6: {
            service = null;
            cmisVersion = null;
            service = this.getService(this.wsContext, repositoryId);
            cmisVersion = this.getCmisVersion(this.wsContext);
            versions = service.getAllVersions(repositoryId, null, versionSeriesId, filter, includeAllowableActions, WSConverter.convert((CmisExtensionType)extension));
            if (versions != null) break block6;
            List<CmisObjectType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            ArrayList<CmisObjectType> result = new ArrayList<CmisObjectType>();
            for (ObjectData object : versions) {
                result.add(WSConverter.convert((ObjectData)object, (CmisVersion)cmisVersion));
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public CmisObjectType getObjectOfLatestVersion(String repositoryId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        CmisService service = null;
        CmisVersion cmisVersion = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisVersion = this.getCmisVersion(this.wsContext);
            cmisObjectType = WSConverter.convert((ObjectData)service.getObjectOfLatestVersion(repositoryId, null, versionSeriesId, major, filter, includeAllowableActions, (IncludeRelationships)WSConverter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeAcl, WSConverter.convert((CmisExtensionType)extension)), (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public CmisPropertiesType getPropertiesOfLatestVersion(String repositoryId, String versionSeriesId, Boolean major, String filter, CmisExtensionType extension) throws CmisException {
        CmisPropertiesType cmisPropertiesType;
        CmisService service = null;
        try {
            service = this.getService(this.wsContext, repositoryId);
            cmisPropertiesType = WSConverter.convert((Properties)service.getPropertiesOfLatestVersion(repositoryId, null, versionSeriesId, major, filter, WSConverter.convert((CmisExtensionType)extension)));
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisPropertiesType;
    }
}

