/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.wss.servlet.BaseWSSFilter;
import org.nuxeo.wss.servlet.config.FilterBindingConfig;

public class WSSFrontFilter
extends BaseWSSFilter
implements Filter {
    @Override
    protected void handleWSSCall(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterBindingConfig config) {
        throw new UnsupportedOperationException("This filter is not intended to receive actual WSS calls, check your configuration");
    }

    @Override
    protected void doForward(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterBindingConfig config) throws ServletException, IOException {
        ServletContext targetContext = this.ctx.getContext(this.getRootFilterTarget());
        if (targetContext != null) {
            targetContext.getRequestDispatcher(httpRequest.getRequestURI()).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        } else {
            String newTarget = this.getRootFilterTarget() + httpRequest.getRequestURI() + "?" + httpRequest.getQueryString();
            httpResponse.sendRedirect(newTarget);
        }
    }

    @Override
    protected boolean isRootFilter() {
        String target = this.filterConfig.getInitParameter("org.nuxeo.wss.rootFilter");
        this.rootFilterTarget = target != null && !"".equals(target) ? target : System.getProperty("org.nuxeo.ecm.contextPath", "/nuxeo");
        return true;
    }

    @Override
    protected void initBackend(FilterConfig filterConfig) {
    }

    @Override
    protected void initHandlers(FilterConfig filterConfig) {
    }
}

