/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.http.listener;

import com.slack.api.util.http.listener.HttpResponseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedLoggingListener
extends HttpResponseListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DetailedLoggingListener.class);

    @Override
    public void accept(HttpResponseListener.State state) {
        if (log.isDebugEnabled()) {
            Response response = state.getResponse();
            String body = state.getParsedResponseBody();
            Buffer requestBody = new Buffer();
            RequestBody requestBodyObj = response.request().body();
            try {
                if (requestBodyObj != null) {
                    requestBodyObj.writeTo((BufferedSink)requestBody);
                }
            }
            catch (IOException e) {
                log.error("Failed to read the request body because {}", (Object)e.getMessage(), (Object)e);
            }
            String textRequestBody = null;
            try {
                textRequestBody = requestBody.buffer().readUtf8();
            }
            catch (Exception e) {
                log.debug("Failed to read request body because {}, error: {}", (Object)e.getMessage(), (Object)e.getClass().getCanonicalName());
            }
            Long contentLength = null;
            try {
                contentLength = requestBodyObj != null ? requestBodyObj.contentLength() : 0L;
            }
            catch (IOException e) {
                log.error("Failed to read the content length because {}", (Object)e.getMessage(), (Object)e);
            }
            Headers originalRequestHeaders = response.request().headers();
            ArrayList<String> requestHeaders = new ArrayList<String>();
            for (String headerName : originalRequestHeaders.names()) {
                if (headerName.toLowerCase(Locale.ENGLISH).equals("authorization") && !state.getConfig().isLibraryMaintainerMode()) {
                    requestHeaders.add(headerName + ": (redacted)");
                    continue;
                }
                requestHeaders.add(headerName + ": " + originalRequestHeaders.get(headerName));
            }
            String requestHeaderLines = requestHeaders.stream().collect(Collectors.joining("\n")) + "\n";
            log.debug("\n[Request URL]\n{} {}\n[Specified Request Headers]\n{}[Request Body]\n{}\n\nContent-Type: {}\nContent Length: {}\n\n[Response Status]\n{} {}\n[Response Headers]\n{}[Response Body]\n{}\n", new Object[]{response.request().method(), response.request().url(), requestHeaderLines, textRequestBody, requestBodyObj != null ? requestBodyObj.contentType() : null, contentLength, response.code(), response.message(), response.headers(), body});
        }
    }
}

