/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim.impl;

import com.slack.api.RequestConfigurator;
import com.slack.api.SlackConfig;
import com.slack.api.methods.impl.MethodsClientImpl;
import com.slack.api.scim.AsyncSCIMClient;
import com.slack.api.scim.SCIMApiRequest;
import com.slack.api.scim.SCIMEndpointName;
import com.slack.api.scim.impl.AsyncRateLimitExecutor;
import com.slack.api.scim.impl.SCIMClientImpl;
import com.slack.api.scim.request.GroupsCreateRequest;
import com.slack.api.scim.request.GroupsDeleteRequest;
import com.slack.api.scim.request.GroupsPatchRequest;
import com.slack.api.scim.request.GroupsReadRequest;
import com.slack.api.scim.request.GroupsSearchRequest;
import com.slack.api.scim.request.GroupsUpdateRequest;
import com.slack.api.scim.request.ServiceProviderConfigsGetRequest;
import com.slack.api.scim.request.UsersCreateRequest;
import com.slack.api.scim.request.UsersDeleteRequest;
import com.slack.api.scim.request.UsersPatchRequest;
import com.slack.api.scim.request.UsersReadRequest;
import com.slack.api.scim.request.UsersSearchRequest;
import com.slack.api.scim.request.UsersUpdateRequest;
import com.slack.api.scim.response.GroupsCreateResponse;
import com.slack.api.scim.response.GroupsDeleteResponse;
import com.slack.api.scim.response.GroupsPatchResponse;
import com.slack.api.scim.response.GroupsReadResponse;
import com.slack.api.scim.response.GroupsSearchResponse;
import com.slack.api.scim.response.GroupsUpdateResponse;
import com.slack.api.scim.response.ServiceProviderConfigsGetResponse;
import com.slack.api.scim.response.UsersCreateResponse;
import com.slack.api.scim.response.UsersDeleteResponse;
import com.slack.api.scim.response.UsersPatchResponse;
import com.slack.api.scim.response.UsersReadResponse;
import com.slack.api.scim.response.UsersSearchResponse;
import com.slack.api.scim.response.UsersUpdateResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSCIMClientImpl
implements AsyncSCIMClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncSCIMClientImpl.class);
    private final String token;
    private final SCIMClientImpl underlying;
    private final AsyncRateLimitExecutor executor;

    public AsyncSCIMClientImpl(String token, SCIMClientImpl scim, MethodsClientImpl methods, SlackConfig config) {
        this.token = token;
        this.underlying = scim;
        this.executor = AsyncRateLimitExecutor.getOrCreate(methods, config);
    }

    private String token(SCIMApiRequest req) {
        if (req.getToken() != null) {
            return req.getToken();
        }
        return this.token;
    }

    private Map<String, String> toMap(SCIMApiRequest req) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", this.token(req));
        return params;
    }

    @Override
    public String getEndpointUrlPrefix() {
        return this.underlying.getEndpointUrlPrefix();
    }

    @Override
    public void setEndpointUrlPrefix(String endpointUrlPrefix) {
        this.underlying.setEndpointUrlPrefix(endpointUrlPrefix);
    }

    @Override
    public CompletableFuture<ServiceProviderConfigsGetResponse> getServiceProviderConfigs(ServiceProviderConfigsGetRequest req) {
        return this.executor.execute(SCIMEndpointName.getServiceProviderConfigs, this.toMap(req), () -> this.underlying.getServiceProviderConfigs(req));
    }

    @Override
    public CompletableFuture<ServiceProviderConfigsGetResponse> getServiceProviderConfigs(RequestConfigurator<ServiceProviderConfigsGetRequest.ServiceProviderConfigsGetRequestBuilder> req) {
        return this.getServiceProviderConfigs(req.configure(ServiceProviderConfigsGetRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersSearchResponse> searchUsers(UsersSearchRequest req) {
        return this.executor.execute(SCIMEndpointName.searchUsers, this.toMap(req), () -> this.underlying.searchUsers(req));
    }

    @Override
    public CompletableFuture<UsersSearchResponse> searchUsers(RequestConfigurator<UsersSearchRequest.UsersSearchRequestBuilder> req) {
        return this.searchUsers(req.configure(UsersSearchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersReadResponse> readUser(UsersReadRequest req) {
        return this.executor.execute(SCIMEndpointName.readUser, this.toMap(req), () -> this.underlying.readUser(req));
    }

    @Override
    public CompletableFuture<UsersReadResponse> readUser(RequestConfigurator<UsersReadRequest.UsersReadRequestBuilder> req) {
        return this.readUser(req.configure(UsersReadRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersCreateResponse> createUser(UsersCreateRequest req) {
        return this.executor.execute(SCIMEndpointName.createUser, this.toMap(req), () -> this.underlying.createUser(req));
    }

    @Override
    public CompletableFuture<UsersCreateResponse> createUser(RequestConfigurator<UsersCreateRequest.UsersCreateRequestBuilder> req) {
        return this.createUser(req.configure(UsersCreateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersPatchResponse> patchUser(UsersPatchRequest req) {
        return this.executor.execute(SCIMEndpointName.patchUser, this.toMap(req), () -> this.underlying.patchUser(req));
    }

    @Override
    public CompletableFuture<UsersPatchResponse> patchUser(RequestConfigurator<UsersPatchRequest.UsersPatchRequestBuilder> req) {
        return this.patchUser(req.configure(UsersPatchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersUpdateResponse> updateUser(UsersUpdateRequest req) {
        return this.executor.execute(SCIMEndpointName.updateUser, this.toMap(req), () -> this.underlying.updateUser(req));
    }

    @Override
    public CompletableFuture<UsersUpdateResponse> updateUser(RequestConfigurator<UsersUpdateRequest.UsersUpdateRequestBuilder> req) {
        return this.updateUser(req.configure(UsersUpdateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<UsersDeleteResponse> deleteUser(UsersDeleteRequest req) {
        return this.executor.execute(SCIMEndpointName.deleteUser, this.toMap(req), () -> this.underlying.deleteUser(req));
    }

    @Override
    public CompletableFuture<UsersDeleteResponse> deleteUser(RequestConfigurator<UsersDeleteRequest.UsersDeleteRequestBuilder> req) {
        return this.deleteUser(req.configure(UsersDeleteRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsSearchResponse> searchGroups(GroupsSearchRequest req) {
        return this.executor.execute(SCIMEndpointName.searchGroups, this.toMap(req), () -> this.underlying.searchGroups(req));
    }

    @Override
    public CompletableFuture<GroupsSearchResponse> searchGroups(RequestConfigurator<GroupsSearchRequest.GroupsSearchRequestBuilder> req) {
        return this.searchGroups(req.configure(GroupsSearchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsReadResponse> readGroup(GroupsReadRequest req) {
        return this.executor.execute(SCIMEndpointName.readGroup, this.toMap(req), () -> this.underlying.readGroup(req));
    }

    @Override
    public CompletableFuture<GroupsReadResponse> readGroup(RequestConfigurator<GroupsReadRequest.GroupsReadRequestBuilder> req) {
        return this.readGroup(req.configure(GroupsReadRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsCreateResponse> createGroup(GroupsCreateRequest req) {
        return this.executor.execute(SCIMEndpointName.createGroup, this.toMap(req), () -> this.underlying.createGroup(req));
    }

    @Override
    public CompletableFuture<GroupsCreateResponse> createGroup(RequestConfigurator<GroupsCreateRequest.GroupsCreateRequestBuilder> req) {
        return this.createGroup(req.configure(GroupsCreateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsPatchResponse> patchGroup(GroupsPatchRequest req) {
        return this.executor.execute(SCIMEndpointName.patchGroup, this.toMap(req), () -> this.underlying.patchGroup(req));
    }

    @Override
    public CompletableFuture<GroupsPatchResponse> patchGroup(RequestConfigurator<GroupsPatchRequest.GroupsPatchRequestBuilder> req) {
        return this.patchGroup(req.configure(GroupsPatchRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsUpdateResponse> updateGroup(GroupsUpdateRequest req) {
        return this.executor.execute(SCIMEndpointName.updateGroup, this.toMap(req), () -> this.underlying.updateGroup(req));
    }

    @Override
    public CompletableFuture<GroupsUpdateResponse> updateGroup(RequestConfigurator<GroupsUpdateRequest.GroupsUpdateRequestBuilder> req) {
        return this.updateGroup(req.configure(GroupsUpdateRequest.builder()).build());
    }

    @Override
    public CompletableFuture<GroupsDeleteResponse> deleteGroup(GroupsDeleteRequest req) {
        return this.executor.execute(SCIMEndpointName.deleteGroup, this.toMap(req), () -> this.underlying.deleteGroup(req));
    }

    @Override
    public CompletableFuture<GroupsDeleteResponse> deleteGroup(RequestConfigurator<GroupsDeleteRequest.GroupsDeleteRequestBuilder> req) {
        return this.deleteGroup(req.configure(GroupsDeleteRequest.builder()).build());
    }
}

