/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.slack.automation;

import com.google.gson.Gson;
import com.slack.api.model.File;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.labs.slack.service.SlackService;

@Operation(id="Slack.UploadFile", category="Notification", label="Send Slack Notification", description="Upload a file to slack. Returns a json object wrapped in a string blob")
public class UploadFileOp {
    public static final String ID = "Slack.UploadFile";
    @Context
    protected CoreSession session;
    @Context
    protected SlackService slackService;

    @OperationMethod
    public Blob run(Blob blob) {
        File slackFile = this.slackService.uploadFile(blob);
        String jsonStr = new Gson().toJson((Object)slackFile);
        return new StringBlob(jsonStr, "application/json");
    }
}

