/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.slack.service;

import com.slack.api.Slack;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import com.slack.api.methods.response.conversations.ConversationsOpenResponse;
import com.slack.api.methods.response.files.FilesUploadResponse;
import com.slack.api.methods.response.users.UsersLookupByEmailResponse;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.slack.service.SlackService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class SlackServiceImpl
extends DefaultComponent
implements SlackService {
    public static final String NUXEO_SLACK_TOKEN_PROPERTY = "nuxeo.slack.token";
    protected volatile Slack slack;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slack getSlackClient() {
        Slack result = this.slack;
        if (result == null) {
            SlackServiceImpl slackServiceImpl = this;
            synchronized (slackServiceImpl) {
                result = this.slack;
                if (result == null) {
                    result = this.slack = Slack.getInstance();
                }
            }
        }
        return result;
    }

    protected String getToken() {
        return Framework.getProperty((String)NUXEO_SLACK_TOKEN_PROPERTY);
    }

    public void activate(ComponentContext context) {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
    }

    public void registerExtension(Extension extension) {
        super.registerExtension(extension);
    }

    public void unregisterExtension(Extension extension) {
        super.unregisterExtension(extension);
    }

    public void start(ComponentContext context) {
    }

    public void stop(ComponentContext context) {
    }

    @Override
    public void sendMessageToChannel(String channel, String message, String blocks) {
        Slack slack = this.getSlackClient();
        try {
            ChatPostMessageResponse response = slack.methods(this.getToken()).chatPostMessage(req -> req.channel(channel).text(message).blocksAsString(blocks));
            if (!response.isOk()) {
                throw new NuxeoException(response.getError());
            }
        }
        catch (SlackApiException | IOException e) {
            throw new NuxeoException(e);
        }
    }

    @Override
    public String getSlackUserId(String email) {
        return this.getSlackUserIds(List.of(email)).get(0);
    }

    @Override
    public List<String> getSlackUserIds(List<String> emailList) {
        Slack slack = this.getSlackClient();
        return emailList.stream().map(email -> {
            try {
                UsersLookupByEmailResponse response = slack.methods(this.getToken()).usersLookupByEmail(req -> req.email(email));
                if (response.isOk()) {
                    return response.getUser().getId();
                }
                throw new NuxeoException("Couldn't get user for " + email + ", " + response.getError());
            }
            catch (SlackApiException | IOException e) {
                throw new NuxeoException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void sendMessageToUser(String slackUserId, String message, String blocks) {
        this.sendMessageToChannel(slackUserId, message, blocks);
    }

    @Override
    public void sendMessageToUsers(List<String> slackUserIds, String message, String blocks) {
        Slack slack = this.getSlackClient();
        try {
            ConversationsOpenResponse conversation = slack.methods(this.getToken()).conversationsOpen(req -> req.users(slackUserIds));
            if (!conversation.isOk()) {
                throw new NuxeoException("Couldn't open conversation " + conversation.getError());
            }
            this.sendMessageToChannel(conversation.getChannel().getId(), message, blocks);
        }
        catch (SlackApiException | IOException e) {
            throw new NuxeoException(e);
        }
    }

    @Override
    public com.slack.api.model.File uploadFile(Blob blob) {
        Slack slack = this.getSlackClient();
        try {
            File file = blob.getCloseableFile().getFile();
            FilesUploadResponse response = slack.methods(this.getToken()).filesUpload(req -> req.file(file).filename(blob.getFilename()));
            if (response.isOk()) {
                return response.getFile();
            }
            throw new NuxeoException("Couldn't upload file " + response.getError());
        }
        catch (SlackApiException | IOException e) {
            throw new NuxeoException(e);
        }
    }
}

