/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.slack.automation;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.labs.slack.service.SlackService;

@Operation(id="Notification.SendSlackNotification", category="Notification", label="Send Slack Notification", description="Send a Slack Notification to a list of users or a channel")
public class SendSlackNotificationOp {
    public static final String ID = "Notification.SendSlackNotification";
    @Context
    protected CoreSession session;
    @Context
    protected SlackService slackService;
    @Context
    protected UserManager userManager;
    @Param(name="channel", required=false)
    protected String channel;
    @Param(name="nuxeoUsernames", required=false)
    protected StringList nuxeoUsernames = new StringList();
    @Param(name="message")
    protected String message;
    @Param(name="blocks", required=false)
    protected String blocks;

    @OperationMethod
    public void run() {
        if (!this.nuxeoUsernames.isEmpty()) {
            List<String> emails = this.nuxeoUsernames.stream().map(username -> this.userManager.getPrincipal(username).getEmail()).collect(Collectors.toList());
            List<String> slackIds = this.slackService.getSlackUserIds(emails);
            this.slackService.sendMessageToUsers(slackIds, this.message, this.blocks);
        } else if (StringUtils.isNotEmpty((CharSequence)this.channel)) {
            this.slackService.sendMessageToChannel(this.channel, this.message, this.blocks);
        }
    }
}

