/*
 * Decompiled with CFR 0.152.
 */
package fr.smile.nuxeo.poc.actions.signdoc;

import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.PdfReader;
import fr.smile.nuxeo.poc.actions.signdoc.SignDocumentActions;
import fr.smile.nuxeo.poc.listener.FileChangesListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.platform.jbpm.JbpmOperation;
import org.nuxeo.ecm.platform.jbpm.JbpmService;
import org.nuxeo.ecm.platform.jbpm.NuxeoJbpmException;
import org.nuxeo.ecm.platform.jbpm.operations.AddCommentOperation;
import org.nuxeo.ecm.platform.jbpm.operations.GetRecipientsForTaskOperation;
import org.nuxeo.ecm.platform.jbpm.web.JbpmActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.invalidations.AutomaticDocumentBasedInvalidation;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.base.InputController;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="signActions")
@AutomaticDocumentBasedInvalidation
public class SignDocumentActionsBean
extends InputController
implements SignDocumentActions,
Serializable {
    private static final long serialVersionUID = -7083809171461269246L;
    private static final Log log = LogFactory.getLog(SignDocumentActionsBean.class);
    private static String SIGN_GRP = "signatories";
    private static final String SIGNED_VALID = "signed, valid";
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient WebActions webActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient JbpmService jbpmService;
    @In(create=true)
    protected transient JbpmActions jbpmActions;
    @In(create=true)
    protected transient UserManager userManager;
    private Boolean fromWorkflow = Boolean.FALSE;
    private TaskInstance currentTask;

    @PrePassivate
    public void saveState() {
        log.info((Object)"SignDocumentActionsBean - PrePassivate");
    }

    @PostActivate
    public void readState() {
        log.info((Object)"SignDocumentActionsBean - PostActivate");
    }

    @Factory(value="hashcodeVerification", scope=ScopeType.EVENT)
    public String verifyHashcode() {
        log.info((Object)"SignDocumentActionsBean -  verifyHashcode");
        String retValue = "";
        try {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            if (currentDoc != null && currentDoc.hasSchema("archievePiece")) {
                if (!SIGNED_VALID.equals(currentDoc.getPropertyValue("archievePiece:status"))) {
                    return retValue;
                }
                Blob current = (Blob)currentDoc.getPropertyValue("file:content");
                Blob copy = (Blob)currentDoc.getPropertyValue("files:files/file[1]/file");
                if (current != null && copy != null) {
                    String copyFileHashCode;
                    SimpleBlobHolder currentbh = new SimpleBlobHolder(current);
                    SimpleBlobHolder copybh = new SimpleBlobHolder(copy);
                    String currentFileHashCode = FileChangesListener.calculateHashcode((BlobHolder)currentbh);
                    if (currentFileHashCode.equals(copyFileHashCode = FileChangesListener.calculateHashcode((BlobHolder)copybh))) {
                        retValue = "Conforme";
                    } else {
                        log.warn((Object)"Hashcode is different");
                        retValue = "Hashcode different ";
                    }
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return retValue;
    }

    private boolean isPdfSigned() throws ClientException {
        log.info((Object)"SignDocumentActionsBean - isPdfSigned");
        this.navigationContext.invalidateCurrentDocument();
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        BlobHolder blob = (BlobHolder)currentDoc.getAdapter(BlobHolder.class);
        try {
            if (blob != null && blob.getBlob() != null) {
                PdfReader reader = new PdfReader(blob.getBlob().getStream());
                AcroFields af = reader.getAcroFields();
                ArrayList names = af.getSignatureNames();
                return names != null && !names.isEmpty();
            }
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return false;
    }

    public String signDocument(TaskInstance taskInstance) throws ClientException {
        log.info((Object)"SignDocumentActionsBean - signDocument");
        this.currentTask = taskInstance;
        this.fromWorkflow = Boolean.TRUE;
        return this.openTabForCurrentDoc("SIGN_PDF");
    }

    public String endSignerTask() throws ClientException {
        if (this.currentTask != null) {
            if (this.isPdfSigned()) {
                this.jbpmActions.validateTask(this.currentTask, null);
            }
            this.currentTask = null;
        }
        this.fromWorkflow = Boolean.FALSE;
        return this.openTabForCurrentDoc("TAB_CONTENT_JBPM");
    }

    private String openTabForCurrentDoc(String tabId) throws ClientException {
        log.info((Object)"SignDocumentActionsBean - openTabForCurrentDoc");
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            currentDocument = this.documentManager.getDocument(currentDocument.getRef());
            this.webActions.setCurrentTabId(tabId);
            return this.navigationContext.navigateToDocument(currentDocument);
        }
        catch (DocumentSecurityException e) {
            this.navigationContext.setCurrentDocument(null);
            return this.navigationContext.goHome();
        }
    }

    @Factory(value="fromWorkflow", scope=ScopeType.EVENT)
    public Boolean getFromWorkflow() {
        log.info((Object)"SignDocumentActionsBean - getFromWorkflow");
        return this.fromWorkflow;
    }

    public void setFromWorkflow(Boolean fromWorkflow) {
        log.info((Object)"SignDocumentActionsBean - setFromWorkflow");
        this.fromWorkflow = fromWorkflow;
    }

    @Override
    public String deleteSrcFile(TaskInstance taskInstance) throws ClientException {
        if (taskInstance != null) {
            DocumentModel dm = this.navigationContext.getCurrentDocument();
            this.deleteSrcFile(dm);
            AddCommentOperation addCommentOperation = new AddCommentOperation(taskInstance.getId(), "user:" + this.currentUser.getName(), "Document file was deleted");
            this.jbpmService.executeJbpmOperation((JbpmOperation)addCommentOperation);
            HashMap<String, Boolean> taskVariables = new HashMap<String, Boolean>();
            taskVariables.put(JbpmService.TaskVariableName.validated.name(), true);
            this.jbpmService.endTask(Long.valueOf(taskInstance.getId()), (String)null, taskVariables, (Map)null, this.getTransientVariables(), (NuxeoPrincipal)this.currentUser);
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.review.task.ended"), new Object[0]);
            Set<String> recipients = this.getRecipientsFromTask(taskInstance);
            this.notifyEventListeners("workflowTaskCompleted", "Document file was deleted", recipients.toArray(new String[0]));
            Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
            this.jbpmActions.resetCurrentData();
            dm.followTransition("destruct");
        }
        return this.returnToCurrentDocOrHome();
    }

    public String conserveSrcFile(TaskInstance taskInstance, String transition) throws ClientException {
        AddCommentOperation addCommentOperation = new AddCommentOperation(taskInstance.getId(), "user:" + this.currentUser.getName(), "Document file was conserved");
        this.jbpmService.executeJbpmOperation((JbpmOperation)addCommentOperation);
        HashMap<String, Boolean> taskVariables = new HashMap<String, Boolean>();
        taskVariables.put(JbpmService.TaskVariableName.validated.name(), true);
        this.jbpmService.endTask(Long.valueOf(taskInstance.getId()), (String)null, taskVariables, (Map)null, this.getTransientVariables(), (NuxeoPrincipal)this.currentUser);
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("label.review.task.ended"), new Object[0]);
        Set<String> recipients = this.getRecipientsFromTask(taskInstance);
        this.notifyEventListeners("workflowTaskCompleted", "Document file was conserved", recipients.toArray(new String[0]));
        Events.instance().raiseEvent("workflowTaskCompleted", new Object[0]);
        this.jbpmActions.resetCurrentData();
        DocumentModel dm = this.navigationContext.getCurrentDocument();
        dm.followTransition("conserve");
        return this.returnToCurrentDocOrHome();
    }

    private void deleteSrcFile(DocumentModel dm) throws ClientException {
        dm.setProperty("file", "filename", null);
        dm.setProperty("file", "content", null);
        this.documentManager.saveDocument(dm);
        this.documentManager.save();
    }

    public void notifyEventListeners(String name, String comment, String[] recipients) throws ClientException {
        this.jbpmService.notifyEventListeners(name, comment, recipients, this.documentManager, (NuxeoPrincipal)this.currentUser, this.navigationContext.getCurrentDocument());
    }

    private Set<String> getRecipientsFromTask(TaskInstance taskInstance) throws NuxeoJbpmException {
        GetRecipientsForTaskOperation operation = new GetRecipientsForTaskOperation(taskInstance.getId());
        return (Set)((Object)this.jbpmService.executeJbpmOperation((JbpmOperation)operation));
    }

    private Map<String, Serializable> getTransientVariables() {
        HashMap<String, Serializable> transientVariables = new HashMap<String, Serializable>();
        transientVariables.put(JbpmService.VariableName.document.name(), (Serializable)this.navigationContext.getCurrentDocument());
        transientVariables.put(JbpmService.VariableName.principal.name(), (Serializable)((NuxeoPrincipal)this.currentUser));
        return transientVariables;
    }

    private String returnToCurrentDocOrHome() throws ClientException {
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            currentDocument = this.documentManager.getDocument(currentDocument.getRef());
            return this.navigationContext.navigateToDocument(currentDocument);
        }
        catch (DocumentSecurityException e) {
            this.navigationContext.setCurrentDocument(null);
            return this.navigationContext.goHome();
        }
    }

    @Override
    public void reinitValues() {
        this.fromWorkflow = Boolean.FALSE;
    }

    @Factory(value="userSessionId", scope=ScopeType.EVENT)
    public String getUserSessionId() {
        return this.documentManager.getSessionId();
    }

    public String encodeFileName(String filename) {
        try {
            return URLEncoder.encode(filename, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return filename;
        }
    }

    @Factory(value="isAllowedToSign", scope=ScopeType.EVENT)
    public boolean isAllowedToSign() throws ClientException {
        List userInGp = this.userManager.getUsersInGroup(SIGN_GRP);
        return userInGp.contains(this.documentManager.getPrincipal().getName());
    }
}

