/*
 * Decompiled with CFR 0.152.
 */
package fr.smile.nuxeo.poc.listener;

import java.io.BufferedReader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Calendar;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class FileChangesListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext docCtx = null;
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        docCtx = (DocumentEventContext)event.getContext();
        String eventId = event.getName();
        if (!(eventId.equals("documentModified") || eventId.equals("documentCreated") || eventId.equals("beforeDocumentModification"))) {
            return;
        }
        DocumentModel currentDoc = docCtx.getSourceDocument();
        if (!currentDoc.isVersion() && !currentDoc.isProxy()) {
            BlobHolder curBlob;
            if (eventId.equals("documentCreated")) {
                currentDoc.setProperty("archievePiece", "status", (Object)"not signed");
            }
            if ((curBlob = (BlobHolder)currentDoc.getAdapter(BlobHolder.class)) != null && curBlob.getBlob() != null) {
                String hashcode = FileChangesListener.calculateHashcode(curBlob);
                currentDoc.setProperty("archievePiece", "hashcode", (Object)hashcode);
                currentDoc.setProperty("archievePiece", "hashcode_date", (Object)Calendar.getInstance().getTime());
            }
        }
    }

    public static String calculateHashcode(BlobHolder blob) throws ClientException {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            BufferedReader blobReader = new BufferedReader(blob.getBlob().getReader());
            int ch = blobReader.read();
            while (ch >= 0) {
                m.update((byte)(ch & 0xFF));
                ch = blobReader.read();
            }
            blobReader.close();
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }
}

