/*
 * Decompiled with CFR 0.152.
 */
package fr.smile.nuxeo.poc.restAPI;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="uploadSignedPdf")
@Scope(value=ScopeType.EVENT)
public class UploadSignedPdf
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    private static final long serialVersionUID = 8780334597831591327L;
    private static final Log log = LogFactory.getLog(UploadSignedPdf.class);
    private static final String SIGNED_VALID = "signed, valid";
    @In(create=true)
    protected NavigationContext navigationContext;
    protected CoreSession documentManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected EventManager eventManager;

    public void handle(Request req, Response res) {
        String docid = (String)req.getAttributes().get("docid");
        String repo = (String)req.getAttributes().get("repo");
        String filename = (String)req.getAttributes().get("filename");
        String user = (String)req.getAttributes().get("user");
        if (repo == null || repo.equals("*")) {
            UploadSignedPdf.handleError((Response)res, (String)"you must specify a repository");
            return;
        }
        log.info((Object)"UploadPdf - handle");
        log.info((Object)(" \t docid " + docid + " -  repo : " + repo + " - filename : " + filename));
        DocumentModel dm = null;
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            if (docid != null) {
                dm = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
                log.info((Object)"Nuxeo Document information ");
                log.info((Object)("\t type " + dm.getType() + " - name : " + dm.getPathAsString() + " - repo " + dm.getRepositoryName()));
            }
        }
        catch (ClientException e) {
            UploadSignedPdf.handleError((Response)res, (Exception)((Object)e));
            return;
        }
        try {
            Blob blob = StreamingBlob.createFromStream((InputStream)req.getEntity().getStream()).persist();
            blob.setFilename(filename);
            try {
                filename = (String)((Object)dm.getPropertyValue("file:filename"));
                ArrayList files = new ArrayList();
                HashMap<String, Object> sign = new HashMap<String, Object>();
                log.info((Object)"add extra attachment - step 2 ");
                sign.put("file", (Serializable)blob);
                sign.put("filename", "signed_" + filename);
                files.add(sign);
                HashMap<String, Object> copy = new HashMap<String, Object>();
                copy.put("file", dm.getPropertyValue("file:content"));
                copy.put("filename", "original_" + filename);
                files.add(copy);
                dm.setPropertyValue("files:files", files);
                log.info((Object)"add extra attachment - step 3 ");
                dm.setProperty("archievePiece", "signed", (Object)user);
            }
            catch (Exception e1) {
                log.error((Object)("Didn't manage to add extra attachment " + e1.toString()));
            }
            dm.setProperty("archievePiece", "status", (Object)SIGNED_VALID);
            log.info((Object)"ArchievePiece status is now 'signed, valid'");
            this.documentManager.saveDocument(dm);
            this.documentManager.save();
            this.navigationContext.invalidateCurrentDocument();
            log.info((Object)"Been saved ? ");
            log.info((Object)("id : " + dm.getId()));
            log.info((Object)("PathAsString : " + dm.getPathAsString()));
            EventManager.raiseEventsOnDocumentChange((DocumentModel)dm);
        }
        catch (Exception e) {
            UploadSignedPdf.handleError((Response)res, (Exception)e);
        }
    }
}

