/*
 * Decompiled with CFR 0.152.
 */
package fr.smile.nuxeo.poc.webapp.helpers;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.webapp.helpers.StartupHelper;

@Name(value="exStartupHelper")
@Scope(value=ScopeType.SESSION)
public class ExtStartupHelper
extends StartupHelper
implements Serializable {
    private static final long serialVersionUID = 3163017418230394890L;
    private static final Log log = LogFactory.getLog(ExtStartupHelper.class);

    public String initDomainAndFindStartupPage(String domainTitle, String viewId) {
        super.initDomainAndFindStartupPage(domainTitle, viewId);
        try {
            DocumentModel domain = this.findDomain(domainTitle);
            if (domain != null) {
                this.navigationContext.setCurrentDomain(this.findDomain(domainTitle));
            }
        }
        catch (ClientException e) {
            log.error((Object)e);
        }
        return this.dashboardNavigationHelper.navigateToDashboard();
    }

    private DocumentModel findDomain(String title) throws ClientException {
        DocumentModel rootDocument = this.documentManager.getRootDocument();
        FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
        LifeCycleFilter lcFilter = new LifeCycleFilter("deleted", false);
        CompoundFilter complexFilter = new CompoundFilter(new Filter[]{facetFilter, lcFilter});
        DocumentModelList domains = this.documentManager.getChildren(rootDocument.getRef(), null, "Read", (Filter)complexFilter, null);
        for (DocumentModel documentModel : domains) {
            if (!title.equals(documentModel.getTitle())) continue;
            return documentModel;
        }
        return null;
    }
}

