/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.activity.stream.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.social.activity.stream.UserActivityStreamPageProvider;

@Operation(id="Services.GetActivityStream", category="Services", label="Get activity stream", description="Get activity stream for the current user.")
public class GetActivityStream {
    public static final String ID = "Services.GetActivityStream";
    public static final String PROVIDER_NAME = "gadget_user_activity_stream";
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService pageProviderService;
    @Param(name="actor", required=false)
    protected String actor;
    @Param(name="language", required=false)
    protected String language;
    @Param(name="activityStreamType", required=false)
    protected String activityStreamType;
    @Param(name="offset", required=false)
    protected Integer offset;
    @Param(name="limit", required=false)
    protected Integer limit;

    @OperationMethod
    public Blob run() throws Exception {
        if (StringUtils.isBlank((String)this.actor)) {
            this.actor = this.session.getPrincipal().getName();
        }
        if (StringUtils.isBlank((String)this.activityStreamType)) {
            this.activityStreamType = "forActor";
        }
        Long targetOffset = 0L;
        if (this.offset != null) {
            targetOffset = this.offset.longValue();
        }
        Long targetLimit = null;
        if (this.limit != null) {
            targetLimit = this.limit.longValue();
        }
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("actor", this.actor);
        props.put("streamType", this.activityStreamType);
        props.put("locale", locale);
        props.put("coreSession", (Serializable)this.session);
        PageProvider pageProvider = this.pageProviderService.getPageProvider(PROVIDER_NAME, null, targetLimit, Long.valueOf(0L), props, new Object[0]);
        pageProvider.setCurrentPageOffset(targetOffset.longValue());
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        ArrayList activities = new ArrayList();
        for (ActivityMessage activityMessage : pageProvider.getCurrentPage()) {
            HashMap<String, Object> o = new HashMap<String, Object>();
            o.put("id", activityMessage.getActivityId());
            o.put("activityMessage", activityMessage.getMessage());
            o.put("publishedDate", dateFormat.format(activityMessage.getPublishedDate()));
            activities.add(o);
        }
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("offset", Long.valueOf(((UserActivityStreamPageProvider)pageProvider).getNextOffset()));
        m.put("limit", Long.valueOf(pageProvider.getPageSize()));
        m.put("activities", activities);
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, m);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }
}

