/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.connectiontracking;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectorInstanceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedConnectorInstanceContext
implements ConnectorInstanceContext {
    private Map<ConnectionTrackingInterceptor, Set<ConnectionInfo>> connectionManagerMap = new HashMap<ConnectionTrackingInterceptor, Set<ConnectionInfo>>();
    private final Set<String> unshareableResources;
    private final Set<String> applicationManagedSecurityResources;
    private boolean hide = false;

    public SharedConnectorInstanceContext(Set<String> unshareableResources, Set<String> applicationManagedSecurityResources, boolean share) {
        this.unshareableResources = unshareableResources;
        this.applicationManagedSecurityResources = applicationManagedSecurityResources;
        if (!share) {
            this.connectionManagerMap = new HashMap<ConnectionTrackingInterceptor, Set<ConnectionInfo>>();
        }
    }

    public void share(SharedConnectorInstanceContext context) {
        this.connectionManagerMap = context.connectionManagerMap;
    }

    public void hide() {
        this.hide = true;
    }

    @Override
    public Map<ConnectionTrackingInterceptor, Set<ConnectionInfo>> getConnectionManagerMap() {
        if (this.hide) {
            return Collections.emptyMap();
        }
        return this.connectionManagerMap;
    }

    @Override
    public Set<String> getUnshareableResources() {
        return this.unshareableResources;
    }

    @Override
    public Set<String> getApplicationManagedSecurityResources() {
        return this.applicationManagedSecurityResources;
    }
}

