/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.activity.AbstractActivityPageProvider;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.social.mini.message.MiniMessage;
import org.nuxeo.ecm.social.mini.message.MiniMessageService;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceMiniMessagePageProvider
extends AbstractActivityPageProvider<MiniMessage> {
    private static final long serialVersionUID = 1L;
    public static final String SOCIAL_WORKSPACE_ID_PROPERTY = "socialWorkspaceId";
    public static final String REPOSITORY_NAME_PROPERTY = "repositoryName";
    public static final String RELATIONSHIP_KIND_PROPERTY = "relationshipKind";
    protected List<MiniMessage> pageMiniMessages;

    public List<MiniMessage> getCurrentPage() {
        if (this.pageMiniMessages == null) {
            this.pageMiniMessages = new ArrayList<MiniMessage>();
            long pageSize = this.getMinMaxPageSize();
            String socialWorkspaceActivityObject = ActivityHelper.createDocumentActivityObject((String)this.getRepositoryName(), (String)this.getSocialWorkspaceId());
            RelationshipKind relationshipKind = this.getRelationshipKind();
            MiniMessageService miniMessageService = (MiniMessageService)Framework.getLocalService(MiniMessageService.class);
            this.pageMiniMessages.addAll(miniMessageService.getMiniMessageFor(socialWorkspaceActivityObject, relationshipKind, socialWorkspaceActivityObject, this.getCurrentPageOffset(), pageSize));
            this.nextOffset = this.offset + (long)this.pageMiniMessages.size();
            this.setResultsCount(-2L);
        }
        return this.pageMiniMessages;
    }

    protected String getSocialWorkspaceId() {
        Map props = this.getProperties();
        String socialWorkspaceId = (String)props.get(SOCIAL_WORKSPACE_ID_PROPERTY);
        if (socialWorkspaceId == null) {
            throw new ClientRuntimeException("Cannot find socialWorkspaceId property.");
        }
        return socialWorkspaceId;
    }

    protected String getRepositoryName() {
        Map props = this.getProperties();
        String repositoryName = (String)props.get(REPOSITORY_NAME_PROPERTY);
        if (repositoryName == null) {
            throw new ClientRuntimeException("Cannot find repositoryName property.");
        }
        return repositoryName;
    }

    protected RelationshipKind getRelationshipKind() {
        Map props = this.getProperties();
        String relationshipKind = (String)props.get(RELATIONSHIP_KIND_PROPERTY);
        if (relationshipKind == null) {
            throw new ClientRuntimeException("Cannot find relationshipKind property.");
        }
        return RelationshipKind.fromString((String)relationshipKind);
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        super.pageChanged();
        this.pageMiniMessages = null;
    }

    public void refresh() {
        super.refresh();
        this.pageMiniMessages = null;
    }
}

