/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class ActivityHelper {
    public static final String SEPARATOR = ":";
    public static final String USER_PREFIX = "user:";
    public static final String DOC_PREFIX = "doc:";

    private ActivityHelper() {
    }

    public static boolean isUser(String activityObject) {
        return activityObject != null && activityObject.startsWith(USER_PREFIX);
    }

    public static boolean isDocument(String activityObject) {
        return activityObject != null && activityObject.startsWith(DOC_PREFIX);
    }

    public static String getUsername(String activityObject) {
        if (!ActivityHelper.isUser(activityObject)) {
            throw new IllegalArgumentException(activityObject + " is not a user activity object");
        }
        return activityObject.replaceAll(USER_PREFIX, "");
    }

    public static List<String> getUsernames(List<String> activityObjects) {
        ArrayList<String> usernames = new ArrayList<String>();
        for (String activityObject : activityObjects) {
            usernames.add(ActivityHelper.getUsername(activityObject));
        }
        return usernames;
    }

    public static String getDocumentId(String activityObject) {
        if (ActivityHelper.isDocument(activityObject)) {
            String[] v = activityObject.split(SEPARATOR);
            return v[2];
        }
        return "";
    }

    public static String getRepositoryName(String activityObject) {
        if (ActivityHelper.isDocument(activityObject)) {
            String[] v = activityObject.split(SEPARATOR);
            return v[1];
        }
        return "";
    }

    public static String createDocumentActivityObject(DocumentModel doc) {
        return ActivityHelper.createDocumentActivityObject(doc.getRepositoryName(), doc.getId());
    }

    public static String createDocumentActivityObject(String repositoryName, String docId) {
        return DOC_PREFIX + repositoryName + SEPARATOR + docId;
    }

    public static String createUserActivityObject(Principal principal) {
        return ActivityHelper.createUserActivityObject(principal.getName());
    }

    public static String createUserActivityObject(String username) {
        return USER_PREFIX + username;
    }

    public static String generateDisplayName(Principal principal) {
        NuxeoPrincipal nuxeoPrincipal;
        if (!(!(principal instanceof NuxeoPrincipal) || StringUtils.isBlank((String)(nuxeoPrincipal = (NuxeoPrincipal)principal).getFirstName()) && StringUtils.isBlank((String)nuxeoPrincipal.getLastName()))) {
            return nuxeoPrincipal.getFirstName() + " " + nuxeoPrincipal.getLastName();
        }
        return principal.getName();
    }

    public static String getDocumentTitle(DocumentModel doc) {
        try {
            return doc.getTitle();
        }
        catch (ClientException e) {
            return doc.getId();
        }
    }

    public static String getDocumentURL(String repositoryName, String documentId) {
        DocumentLocationImpl docLoc = new DocumentLocationImpl(repositoryName, (DocumentRef)new IdRef(documentId));
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)docLoc, "view_documents");
        return VirtualHostHelper.getContextPathProperty() + "/" + ActivityHelper.getURLPolicyService().getUrlFromDocumentView("id", (DocumentView)docView, null);
    }

    public static String getUserProfileURL(String username) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        DocumentViewImpl docView = new DocumentViewImpl(null, null, params);
        return VirtualHostHelper.getContextPathProperty() + "/" + ActivityHelper.getURLPolicyService().getUrlFromDocumentView("user", (DocumentView)docView, null);
    }

    public static String getDocumentLink(String documentActivityObject, String displayValue) {
        documentActivityObject = StringEscapeUtils.escapeHtml((String)documentActivityObject);
        displayValue = StringEscapeUtils.escapeHtml((String)displayValue);
        String link = "<a href=\"%s\" target=\"_top\">%s</a>";
        return String.format(link, ActivityHelper.getDocumentURL(ActivityHelper.getRepositoryName(documentActivityObject), ActivityHelper.getDocumentId(documentActivityObject)), displayValue);
    }

    public static String getUserProfileLink(String userActivityObject, String displayValue) {
        userActivityObject = StringEscapeUtils.escapeHtml((String)userActivityObject);
        displayValue = StringEscapeUtils.escapeHtml((String)displayValue);
        String link = "<a href=\"%s\" target=\"_top\" title=\"%s\">%s</a>";
        String username = ActivityHelper.getUsername(userActivityObject);
        return String.format(link, ActivityHelper.getUserProfileURL(username), username, displayValue);
    }

    private static URLPolicyService getURLPolicyService() {
        URLPolicyService urlPolicyService;
        try {
            urlPolicyService = (URLPolicyService)Framework.getService(URLPolicyService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        if (urlPolicyService == null) {
            throw new ClientRuntimeException("URLPolicyService service is not registered.");
        }
        return urlPolicyService;
    }
}

