/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.adapters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.social.workspace.adapters.Article;
import org.nuxeo.ecm.social.workspace.adapters.ArticleAdapter;
import org.nuxeo.ecm.social.workspace.adapters.SocialDocumentAdapter;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspaceAdapter;
import org.nuxeo.ecm.social.workspace.adapters.SubscriptionRequest;
import org.nuxeo.ecm.social.workspace.adapters.SubscriptionRequestAdapter;

public class AdapterFactory
implements DocumentAdapterFactory {
    private static final Log log = LogFactory.getLog(AdapterFactory.class);

    public Object getAdapter(DocumentModel doc, Class<?> itf) {
        if (doc.hasFacet("SocialWorkspace")) {
            return new SocialWorkspaceAdapter(doc);
        }
        if (doc.hasFacet("SocialDocument")) {
            try {
                return new SocialDocumentAdapter(doc);
            }
            catch (ClientException e) {
                log.error((Object)(e.getMessage() + " : Adapter returned is null"));
                log.debug((Object)e, (Throwable)e);
            }
        }
        if (itf == Article.class && "Article".equals(doc.getType())) {
            return new ArticleAdapter(doc);
        }
        if (itf == SubscriptionRequest.class && doc.hasSchema("subscription_request")) {
            return new SubscriptionRequestAdapter(doc);
        }
        return null;
    }
}

