/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.adapters;

import java.io.Serializable;
import java.security.Principal;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.social.workspace.adapters.SocialDocument;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.listeners.VisibilitySocialDocumentListener;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class SocialDocumentAdapter
implements SocialDocument {
    protected DocumentModel sourceDocument;
    protected SocialWorkspace socialWorkspace;
    protected DocumentModel privateSocialSection;
    protected DocumentModel publicSocialSection;
    private CoreSession session;

    public SocialDocumentAdapter(DocumentModel sourceDocument) throws ClientException {
        this.sourceDocument = sourceDocument;
        if (sourceDocument != null && this.getSession() == null) {
            throw new ClientException("All action will be impossible as the given getSession() is null");
        }
        if (sourceDocument == null) {
            throw new ClientException("Give document model is null");
        }
        if (!SocialWorkspaceHelper.isSocialDocument(sourceDocument)) {
            throw new ClientException("Make public a document is restricted to social document only not for :" + sourceDocument.getPathAsString());
        }
        this.socialWorkspace = SocialDocumentAdapter.getSocialWorkspaceService().getDetachedSocialWorkspace(sourceDocument);
        if (this.socialWorkspace == null) {
            throw new ClientException("Given document is not into a social workspace");
        }
    }

    protected DocumentModel getPrivateSection() throws ClientException {
        PathRef pathRef = new PathRef(this.socialWorkspace.getPrivateSectionPath());
        if (this.privateSocialSection == null) {
            this.privateSocialSection = this.getSession().getDocument((DocumentRef)pathRef);
        }
        return this.privateSocialSection;
    }

    protected DocumentModel getPublicSection() throws ClientException {
        PathRef pathRef = new PathRef(this.socialWorkspace.getPublicSectionPath());
        if (this.publicSocialSection == null) {
            this.publicSocialSection = this.getSession().getDocument((DocumentRef)pathRef);
        }
        return this.publicSocialSection;
    }

    @Override
    public DocumentModel restrictToMembers() throws ClientException {
        this.setIsPublicField(false);
        DocumentModel privateProxy = this.getPrivateProxy();
        if (privateProxy != null) {
            return this.updateExposedDocument(privateProxy, false);
        }
        DocumentModel publicProxy = this.getPublicProxy();
        if (publicProxy != null) {
            if ("Article".equals(this.sourceDocument.getType())) {
                this.getSession().removeDocument(publicProxy.getRef());
            } else {
                return this.updateExposedDocument(publicProxy, false);
            }
        }
        if ("Article".equals(this.sourceDocument.getType())) {
            return this.sourceDocument;
        }
        DocumentModel exposedDocument = this.getSession().publishDocument(this.sourceDocument, this.getPrivateSection());
        this.getSession().save();
        return exposedDocument;
    }

    @Override
    public DocumentModel makePublic() throws ClientException {
        this.setIsPublicField(true);
        DocumentModel publicProxy = this.getPublicProxy();
        if (publicProxy != null) {
            return this.updateExposedDocument(publicProxy, true);
        }
        DocumentModel privateProxy = this.getPrivateProxy();
        if (privateProxy != null) {
            return this.updateExposedDocument(privateProxy, true);
        }
        DocumentModel exposedDocument = this.getSession().publishDocument(this.sourceDocument, this.getPublicSection());
        this.getSession().save();
        this.addMakeDocumentPublicActivity(exposedDocument, this.session.getPrincipal());
        return exposedDocument;
    }

    protected void setIsPublicField(boolean value) throws ClientException {
        this.sourceDocument.setPropertyValue("socialdoc:isPublic", (Serializable)Boolean.valueOf(value));
        this.sourceDocument.putContextData(VisibilitySocialDocumentListener.ALREADY_PROCESSED, (Serializable)Boolean.valueOf(true));
        this.sourceDocument = this.session.saveDocument(this.sourceDocument);
    }

    protected DocumentModel getPublicProxy() throws ClientException {
        DocumentModelList proxies = this.getSession().getProxies(this.sourceDocument.getRef(), this.getPublicSection().getRef());
        this.validateDocumentVisibility(proxies, true);
        if (proxies.size() == 1) {
            return (DocumentModel)proxies.get(0);
        }
        return null;
    }

    protected DocumentModel getPrivateProxy() throws ClientException {
        DocumentModelList proxies = this.getSession().getProxies(this.sourceDocument.getRef(), this.getPrivateSection().getRef());
        this.validateDocumentVisibility(proxies, false);
        if (proxies.size() == 1) {
            return (DocumentModel)proxies.get(0);
        }
        return null;
    }

    protected void validateDocumentVisibility(DocumentModelList proxies, boolean isPublicProxies) throws ClientException {
        if (proxies.size() > 1) {
            String message = String.format("Too many published document: %s, please check." + this.sourceDocument.getPathAsString(), new Object[0]);
            throw new ClientException(message);
        }
        if (!isPublicProxies && "Article".equals(this.sourceDocument.getType()) && proxies.size() == 1) {
            String message = String.format("Article can't have a private proxy: %s, please check." + this.sourceDocument.getPathAsString(), new Object[0]);
            throw new ClientException(message);
        }
    }

    protected void addMakeDocumentPublicActivity(DocumentModel doc, Principal principal) {
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        Activity activity = new ActivityBuilder().verb("makedocumentpublic").actor(ActivityHelper.createUserActivityObject((Principal)principal)).displayActor(ActivityHelper.generateDisplayName((Principal)principal)).object(ActivityHelper.createDocumentActivityObject((DocumentModel)doc)).displayObject(ActivityHelper.getDocumentTitle((DocumentModel)doc)).target(ActivityHelper.createDocumentActivityObject((DocumentModel)this.socialWorkspace.getDocument())).displayTarget(this.socialWorkspace.getTitle()).build();
        activityStreamService.addActivity(activity);
    }

    @Override
    public DocumentModel getPublicDocument() throws ClientException {
        return this.getPublicProxy();
    }

    @Override
    public boolean isPublic() throws ClientException {
        return (Boolean)this.sourceDocument.getPropertyValue("socialdoc:isPublic");
    }

    @Override
    public DocumentModel getRestrictedDocument() throws ClientException {
        if ("Article".equals(this.sourceDocument.getType())) {
            if (this.isPublic()) {
                return null;
            }
            return this.sourceDocument;
        }
        return this.getPrivateProxy();
    }

    @Override
    public boolean isRestrictedToMembers() throws ClientException {
        return (Boolean)this.sourceDocument.getPropertyValue("socialdoc:isPublic") == false;
    }

    @Override
    public boolean isDocumentInSocialWorkspace() {
        return this.socialWorkspace != null;
    }

    protected DocumentModel updateExposedDocument(DocumentModel exposedDocument, boolean isPublic) throws ClientException {
        if (!exposedDocument.isProxy() && isPublic) {
            exposedDocument = this.getSession().publishDocument(this.sourceDocument, this.getPublicProxy());
            this.getSession().save();
            return exposedDocument;
        }
        if (!exposedDocument.isProxy() && !isPublic) {
            return exposedDocument;
        }
        DocumentModel targetSection = isPublic ? this.getPublicSection() : this.getPrivateSection();
        DocumentModel currentTarget = this.getSession().getDocument(exposedDocument.getParentRef());
        exposedDocument = this.getSession().publishDocument(this.sourceDocument, currentTarget, true);
        if (!currentTarget.getId().equals(targetSection.getId())) {
            exposedDocument = this.getSession().move(exposedDocument.getRef(), targetSection.getRef(), exposedDocument.getName());
        }
        this.getSession().save();
        return exposedDocument;
    }

    @Override
    public String getType() {
        return this.sourceDocument.getType();
    }

    protected CoreSession getSession() {
        if (this.session == null) {
            this.session = this.sourceDocument.getCoreSession();
        }
        return this.session;
    }

    private static SocialWorkspaceService getSocialWorkspaceService() {
        try {
            return (SocialWorkspaceService)Framework.getService(SocialWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

