/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceEmailNotifier;

public class SubscriptionRequestListener
implements PostCommitEventListener {
    private final SocialWorkspaceEmailNotifier emailNotifier = new SocialWorkspaceEmailNotifier();

    public void handleEvent(EventBundle eventBundle) throws ClientException {
        if (eventBundle.containsEventName("subscriptionRequestCreated") || eventBundle.containsEventName("subscriptionRequestAccepted") || eventBundle.containsEventName("subscriptionRequestRejected")) {
            for (Event event : eventBundle) {
                this.handleEvent(event);
            }
        }
    }

    private void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        CoreSession session = docCtx.getCoreSession();
        if ("subscriptionRequestCreated".equals(event.getName())) {
            this.emailNotifier.notifyAdministratorsForNewSubscriptionRequest(session, doc);
        } else if ("subscriptionRequestAccepted".equals(event.getName())) {
            String principalName = (String)((Object)docCtx.getProperty("principalName"));
            this.emailNotifier.notifyUserForSubscriptionRequestAccepted(session, SocialWorkspaceHelper.toSocialWorkspace(doc), principalName);
        } else if ("subscriptionRequestRejected".equals(event.getName())) {
            String principalName = (String)((Object)docCtx.getProperty("principalName"));
            this.emailNotifier.notifyUserForSubscriptionRequestRejected(session, SocialWorkspaceHelper.toSocialWorkspace(doc), principalName);
        }
    }
}

