/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets.webengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.util.PaginableDocumentModelList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.TypeService;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.TypeView;
import org.nuxeo.ecm.social.workspace.adapters.SocialDocument;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/social")
@WebObject(type="social")
@Produces(value={"text/html; charset=UTF-8"})
public class SocialWebEngineRoot
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(SocialWebEngineRoot.class);
    static AutomationService automationService;

    @POST
    @Path(value="documentList")
    public Object documentList(@Context HttpServletRequest request) throws Exception {
        FormData formData = new FormData(request);
        String lang = formData.getString("lang");
        this.setLanguage(lang);
        String ref = formData.getString("docRef");
        String queryText = formData.getString("queryText");
        int pageSize = SocialWebEngineRoot.getIntFromString(formData.getString("limit"));
        int page = SocialWebEngineRoot.getIntFromString(formData.getString("page"));
        return this.buildDocumentList(ref, pageSize, page, queryText);
    }

    Object buildDocumentList(String ref, int pageSize, int page, String queryText) throws Exception {
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(ref);
        return this.buildDocumentList(docRef, pageSize, page, queryText);
    }

    Object buildDocumentList(DocumentRef docRef, int pageSize, int page, String queryText) throws Exception {
        PaginableDocumentModelList docs;
        boolean isSearch = queryText != null && queryText.trim().length() > 0;
        HashMap<String, Object> args = new HashMap<String, Object>();
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel doc = session.getDocument(docRef);
        args.put("currentDoc", doc);
        DocumentModel socialWorkspace = null;
        if (isSearch) {
            docs = SocialWebEngineRoot.search(doc, pageSize, page, queryText);
            socialWorkspace = doc;
            args.put("queryText", queryText);
        } else {
            docs = SocialWebEngineRoot.getChildren(doc, pageSize, page);
            List<DocumentModel> ancestors = SocialWebEngineRoot.getAncestors(doc);
            DocumentModel parent = null;
            if (ancestors.size() > 1) {
                parent = ancestors.get(ancestors.size() - 2);
            }
            args.put("parent", parent);
            if (!ancestors.isEmpty() && SocialWebEngineRoot.isSocialWorkspace(ancestors.get(0))) {
                socialWorkspace = ancestors.remove(0);
            }
            args.put("ancestors", ancestors);
            args.put("queryText", "");
        }
        args.put("socialWorkspace", socialWorkspace);
        args.put("docs", docs);
        args.put("publishablePublic", SocialWebEngineRoot.getPublishableDocs(socialWorkspace, (DocumentModelList)docs, true));
        args.put("publishablePrivate", SocialWebEngineRoot.getPublishableDocs(socialWorkspace, (DocumentModelList)docs, false));
        args.put("removable", SocialWebEngineRoot.getDocsWithDeleteRight((DocumentModelList)docs));
        args.put("isPublicSocialWorkspace", socialWorkspace.getPropertyValue("socialw:isPublic"));
        args.put("collaboration_views", SocialWebEngineRoot.getCollaborationViews((DocumentModelList)docs));
        args.put("page", docs.getCurrentPageIndex());
        args.put("maxPage", docs.getNumberOfPages());
        args.put("nextPage", (long)page < docs.getNumberOfPages() - 1L ? page + 1 : page);
        args.put("prevPage", page > 0 ? page - 1 : page);
        if (isSearch) {
            return this.getView("search_result").args(args);
        }
        return this.getView("children_list").args(args);
    }

    @POST
    @Path(value="publishDocument")
    public Object publishDocument(@Context HttpServletRequest request) throws Exception {
        DocumentRef docRef;
        FormData formData = new FormData(request);
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel target = session.getDocument(docRef = SocialWebEngineRoot.getDocumentRef(formData.getString("targetRef")));
        SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)target);
        if (socialDocument == null) {
            throw new ClientException("Can't fetch social document.");
        }
        boolean isPublic = "true".equals(formData.getString("public"));
        if (isPublic) {
            socialDocument.makePublic();
        } else {
            socialDocument.restrictToMembers();
        }
        return this.documentList(request);
    }

    @POST
    @Path(value="deleteDocument")
    public Object deleteDocument(@Context HttpServletRequest request) throws Exception {
        FormData formData = new FormData(request);
        String target = formData.getString("targetRef");
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(target);
        CoreSession session = this.ctx.getCoreSession();
        if (session.getAllowedStateTransitions(docRef).contains("delete")) {
            session.followTransition(docRef, "delete");
        } else {
            session.removeDocument(docRef);
        }
        return this.documentList(request);
    }

    @GET
    @Path(value="createDocumentForm")
    public Object createDocumentForm(@QueryParam(value="docRef") String ref, @QueryParam(value="doctype") String docTypeId, @QueryParam(value="lang") String lang) throws Exception {
        this.setLanguage(lang);
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(ref);
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel currentDoc = session.getDocument(docRef);
        DocumentType coreType = TypeService.getSchemaManager().getDocumentType(docTypeId);
        return this.getView("create_document_form").arg("currentDoc", (Object)currentDoc).arg("docType", (Object)SocialWebEngineRoot.getTypeService().getType(docTypeId)).arg("coreType", (Object)coreType);
    }

    @GET
    @Path(value="selectDocTypeToCreate")
    public Object selectDocTypeToCreate(@QueryParam(value="docRef") String ref, @QueryParam(value="lang") String lang) throws ClientException {
        this.setLanguage(lang);
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(ref);
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel currentDoc = session.getDocument(docRef);
        TypeManager typeService = SocialWebEngineRoot.getTypeService();
        Map types = typeService.getTypeMapForDocumentType(currentDoc.getType(), currentDoc);
        return this.getView("select_doc_type").arg("currentDoc", (Object)currentDoc).arg("docTypes", (Object)types).arg("categories", types.keySet()).arg("lang", (Object)lang);
    }

    protected static TypeManager getTypeService() throws ClientException {
        TypeManager typeService;
        try {
            typeService = (TypeManager)Framework.getService(TypeManager.class);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
        if (typeService == null) {
            throw new ClientException("Can't fetch the typeService, please contact your administrator");
        }
        return typeService;
    }

    @POST
    @Path(value="createDocument")
    public Object createDocument(@Context HttpServletRequest request) throws Exception {
        CoreSession session = this.ctx.getCoreSession();
        FormData formData = new FormData(request);
        String type = formData.getDocumentType();
        String title = formData.getDocumentTitle();
        DocumentRef docRef = SocialWebEngineRoot.getDocumentRef(formData.getString("docRef"));
        DocumentModel parent = session.getDocument(docRef);
        DocumentModel newDoc = session.createDocumentModel(parent.getPathAsString(), title, type);
        formData.fillDocument(newDoc);
        newDoc = session.createDocument(newDoc);
        session.save();
        if (newDoc.isFolder()) {
            return this.buildDocumentList(newDoc.getId(), 0, 0, null);
        }
        return this.buildDocumentList(parent.getId(), 0, 0, null);
    }

    protected static PaginableDocumentModelList getChildren(DocumentModel doc, int pageSize, int page) throws Exception {
        CoreSession session = doc.getCoreSession();
        OperationContext ctx = new OperationContext(session);
        OperationChain chain = new OperationChain("getChildren");
        String query = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'AND ecm:parentId = '" + doc.getId() + "'";
        chain.add("Document.PageProvider").set("query", (Object)query).set("pageSize", (Object)pageSize).set("page", (Object)page);
        return (PaginableDocumentModelList)SocialWebEngineRoot.getAutomationService().run(ctx, chain);
    }

    protected static PaginableDocumentModelList search(DocumentModel doc, int pageSize, int page, String queryText) throws Exception {
        CoreSession session = doc.getCoreSession();
        OperationContext ctx = new OperationContext(session);
        OperationChain chain = new OperationChain("search");
        String escapedQueryText = NXQLQueryBuilder.prepareStringLiteral((String)queryText.trim(), (boolean)false, (boolean)true);
        String query = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted' AND ecm:fulltext = '" + escapedQueryText + "' " + "AND ecm:path STARTSWITH '" + doc.getPathAsString() + "'";
        chain.add("Document.PageProvider").set("query", (Object)query).set("limit", (Object)pageSize).set("page", (Object)page);
        return (PaginableDocumentModelList)SocialWebEngineRoot.getAutomationService().run(ctx, chain);
    }

    protected static List<DocumentModel> getAncestors(DocumentModel doc) throws ClientException {
        ArrayList<DocumentModel> list = new ArrayList<DocumentModel>();
        CoreSession session = doc.getCoreSession();
        list.add(doc);
        while (doc != null && !SocialWebEngineRoot.isSocialWorkspace(doc)) {
            doc = session.getParentDocument(doc.getRef());
            list.add(0, doc);
        }
        return list;
    }

    protected static boolean isSocialWorkspace(DocumentModel doc) {
        return doc != null && doc.hasFacet("SocialWorkspace");
    }

    protected static DocumentRef getDocumentRef(String ref) {
        Object docRef = ref != null && ref.startsWith("/") ? new PathRef(ref) : new IdRef(ref);
        return docRef;
    }

    protected void setLanguage(String lang) {
        if (lang != null && lang.trim().length() > 0) {
            Locale locale = new Locale(lang);
            this.ctx.setLocale(locale);
        }
    }

    protected static int getIntFromString(String value) {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static AutomationService getAutomationService() throws Exception {
        if (automationService == null) {
            automationService = (AutomationService)Framework.getService(AutomationService.class);
        }
        return automationService;
    }

    protected static List<String> getPublishableDocs(DocumentModel socialWorkspace, DocumentModelList docs, boolean isPublic) throws ClientException {
        ArrayList<String> list;
        block4: {
            boolean isPublicSocialWorkspace = (Boolean)socialWorkspace.getPropertyValue("socialw:isPublic");
            list = new ArrayList<String>();
            if (!isPublicSocialWorkspace) break block4;
            if (isPublic) {
                for (DocumentModel doc : docs) {
                    SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)doc);
                    if (socialDocument == null || !socialDocument.isRestrictedToMembers()) continue;
                    list.add(doc.getId());
                }
            } else {
                for (DocumentModel doc : docs) {
                    SocialDocument socialDocument = SocialWorkspaceHelper.toSocialDocument((DocumentModel)doc);
                    if (socialDocument == null || !socialDocument.isPublic()) continue;
                    list.add(doc.getId());
                }
            }
        }
        return list;
    }

    protected static List<String> getDocsWithDeleteRight(DocumentModelList docs) throws ClientException {
        ArrayList<String> docsIdResult = new ArrayList<String>();
        if (docs.isEmpty()) {
            return docsIdResult;
        }
        CoreSession session = ((DocumentModel)docs.get(0)).getCoreSession();
        for (DocumentModel doc : docs) {
            if (!session.hasPermission(doc.getRef(), "Remove") || !session.hasPermission(session.getParentDocumentRef(doc.getRef()), "RemoveChildren")) continue;
            docsIdResult.add(doc.getId());
        }
        return docsIdResult;
    }

    protected static Map<String, String> getCollaborationViews(DocumentModelList docs) throws ClientException {
        TypeManager typeManager;
        HashMap<String, String> viewResults = new HashMap<String, String>();
        if (docs.isEmpty()) {
            return viewResults;
        }
        try {
            typeManager = (TypeManager)Framework.getService(TypeManager.class);
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), (Throwable)e);
        }
        for (DocumentModel doc : docs) {
            Type type = typeManager.getType(doc.getType());
            TypeView view = type.getView("collaboration");
            if (view != null) {
                viewResults.put(doc.getId(), view.getValue());
                continue;
            }
            viewResults.put(doc.getId(), type.getDefaultView());
        }
        return viewResults;
    }

    public String getTranslatedLabel(String label) {
        String newLabel = I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)this.ctx.getLocale());
        if (newLabel == null) {
            return label;
        }
        return newLabel;
    }

    public Blob getAttachment(DocumentModel doc) throws ClientException {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        return bh != null ? bh.getBlob() : null;
    }

    public String escape(String text) {
        text = StringEscapeUtils.escapeJavaScript((String)text);
        text = StringEscapeUtils.escapeHtml((String)text);
        text = StringEscapeUtils.escapeXml((String)text);
        return text;
    }

    public String escapePath(String text) {
        text = text.replaceAll("'", Matcher.quoteReplacement("\\'"));
        try {
            text = URIUtil.encodePath((String)text);
        }
        catch (Exception e) {
            log.debug((Object)("failed to encode:" + text), (Throwable)e);
        }
        return text;
    }

    public boolean hasAddChildrenRight(String docId) {
        try {
            IdRef docRef = new IdRef(docId);
            boolean hasPermission = this.ctx.getCoreSession().hasPermission((DocumentRef)docRef, "AddChildren");
            return hasPermission;
        }
        catch (Exception e) {
            return false;
        }
    }
}

