/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.adapters.SubscriptionRequest;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceEmailNotifier {
    private static final Log log = LogFactory.getLog(SocialWorkspaceEmailNotifier.class);
    private static final String TEMPLATE_JOIN_REQUEST_RECEIVED = "templates/joinRequestReceived.ftl";
    private static final String TEMPLATE_JOIN_REQUEST_ACCEPTED = "templates/joinRequestAccepted.ftl";
    private static final String TEMPLATE_JOIN_REQUEST_REJECTED = "templates/joinRequestRejected.ftl";
    private AutomationService automationService;
    private UserManager userManager;

    public void notifyAdministratorsForNewSubscriptionRequest(CoreSession session, DocumentModel subscriptionRequest) throws ClientException {
        SubscriptionRequest requestAdapter = (SubscriptionRequest)subscriptionRequest.getAdapter(SubscriptionRequest.class);
        DocumentModel socialWorkspaceDoc = session.getDocument((DocumentRef)new IdRef(requestAdapter.getInfo()));
        SocialWorkspace socialWorkspace = SocialWorkspaceHelper.toSocialWorkspace(socialWorkspaceDoc);
        List<String> admins = socialWorkspace.getAdministrators();
        if (admins == null || admins.isEmpty()) {
            log.warn((Object)String.format("No admin users for social workspace %s (%s) ", socialWorkspace.getTitle(), socialWorkspace.getPath()));
            return;
        }
        StringList toList = new StringList();
        for (String adminName : admins) {
            NuxeoPrincipal admin = this.getUserManager().getPrincipal(adminName);
            String email = admin.getEmail();
            if (email == null) continue;
            toList.add((Object)email);
        }
        if (toList.isEmpty()) {
            log.warn((Object)"no admin email found ...");
            return;
        }
        Expression subject = Scripting.newTemplate((String)"Join request received from ${Context.subscriptionRequestUser.firstName} ${Context.subscriptionRequestUser.lastName} ");
        String template = SocialWorkspaceEmailNotifier.loadTemplate(TEMPLATE_JOIN_REQUEST_RECEIVED);
        OperationContext ctx = new OperationContext(session);
        ctx.setInput((Object)socialWorkspaceDoc);
        NuxeoPrincipal subscriptionRequestUser = this.getUserManager().getPrincipal(requestAdapter.getUsername());
        ctx.put("subscriptionRequestUser", (Object)subscriptionRequestUser);
        OperationChain chain = new OperationChain("sendEMail");
        chain.add("Notification.SendMail").set("from", (Object)"admin@nuxeo.org").set("to", (Object)toList).set("subject", (Object)subject).set("HTML", (Object)true).set("message", (Object)template);
        try {
            this.getAutomationService().run(ctx, chain);
        }
        catch (Exception e) {
            String message = String.format("Failed to notify administrators of Social Workspace '%s': %s", socialWorkspaceDoc.getPath(), e.getMessage());
            log.warn((Object)message);
            log.debug((Object)e, (Throwable)e);
        }
    }

    public void notifyUserForSubscriptionRequestAccepted(CoreSession session, SocialWorkspace socialWorkspace, String principalName) throws ClientException {
        this.notifyUser(session, socialWorkspace, principalName, true);
    }

    public void notifyUserForSubscriptionRequestRejected(CoreSession session, SocialWorkspace socialWorkspace, String principalName) throws ClientException {
        this.notifyUser(session, socialWorkspace, principalName, false);
    }

    private void notifyUser(CoreSession session, SocialWorkspace socialWorkspace, String principalName, boolean accepted) throws ClientException {
        String subject;
        String template;
        NuxeoPrincipal principal = this.getUserManager().getPrincipal(principalName);
        String email = principal.getEmail();
        if (email == null || email.trim().length() == 0) {
            log.debug((Object)("email not defined for user:" + principalName));
            return;
        }
        if (accepted) {
            template = SocialWorkspaceEmailNotifier.loadTemplate(TEMPLATE_JOIN_REQUEST_ACCEPTED);
            subject = "Join request accepted";
        } else {
            template = SocialWorkspaceEmailNotifier.loadTemplate(TEMPLATE_JOIN_REQUEST_REJECTED);
            subject = "Join request rejected";
        }
        OperationContext ctx = new OperationContext(session);
        ctx.setInput((Object)socialWorkspace.getDocument());
        OperationChain chain = new OperationChain("sendEMail");
        chain.add("Notification.SendMail").set("from", (Object)"admin@nuxeo.org").set("to", (Object)email).set("subject", (Object)subject).set("HTML", (Object)true).set("message", (Object)template);
        try {
            this.getAutomationService().run(ctx, chain);
        }
        catch (Exception e) {
            String message = String.format("Failed to notify '%s' user for Social Workspace '%s': %s", principal, socialWorkspace.getPath(), e.getMessage());
            log.warn((Object)message);
            log.debug((Object)e, (Throwable)e);
        }
    }

    private static String loadTemplate(String key) {
        InputStream io = SocialWorkspaceServiceImpl.class.getClassLoader().getResourceAsStream(key);
        if (io != null) {
            try {
                String string = FileUtils.read((InputStream)io);
                return string;
            }
            catch (IOException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            finally {
                try {
                    io.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private AutomationService getAutomationService() {
        if (this.automationService == null) {
            try {
                this.automationService = (AutomationService)Framework.getService(AutomationService.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return this.automationService;
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return this.userManager;
    }
}

