/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="bulkImportSocialWorkspaceActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class BulkImportSocialWorkspaceActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String USERS_IMPORTED_LABEL = "label.social.workspace.users.imported";
    public static final String USERS_NOT_IMPORTED_LABEL = "label.social.workspace.users.imported.not";
    public static final String USERS_IMPORTED_ERROR_LABEL = "label.social.workspace.users.imported.error";
    private static final String MEMBER_NOTIFICATION_DISABLED = "memberNotificationDisabled";
    private static final Log log = LogFactory.getLog(BulkImportSocialWorkspaceActions.class);
    @In(create=true)
    protected transient SocialWorkspaceService socialWorkspaceService;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    protected String rawListOfEmails;
    protected List<String> groupsToImport;

    public List<String> getGroupsToImport() {
        return this.groupsToImport;
    }

    public void setGroupsToImport(List<String> selectedGroups) {
        this.groupsToImport = selectedGroups;
    }

    public String getRawListOfEmails() {
        return this.rawListOfEmails;
    }

    public void setRawListOfEmails(String rawListOfEmails) {
        this.rawListOfEmails = rawListOfEmails;
    }

    public void importUserFromListOfEmail() {
        ArrayList<String> emails = new ArrayList<String>(Arrays.asList(this.rawListOfEmails.split("\\s")));
        SocialWorkspace socialWorkspace = SocialWorkspaceHelper.toSocialWorkspace((DocumentModel)this.navigationContext.getCurrentDocument());
        try {
            List emailOfUsersAdded = this.socialWorkspaceService.addSocialWorkspaceMembers(socialWorkspace, emails);
            emails.removeAll(emailOfUsersAdded);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(USERS_IMPORTED_LABEL), new Object[]{emailOfUsersAdded.size(), this.convertToString(emailOfUsersAdded)});
            if (!emails.isEmpty()) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get(USERS_NOT_IMPORTED_LABEL), new Object[]{emails.size(), this.convertToString(emails)});
            }
            this.resetMemberNotificationDisabled(socialWorkspace);
            this.resetRawListOfEmails();
        }
        catch (ClientException e) {
            log.warn((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get(USERS_IMPORTED_ERROR_LABEL), new Object[0]);
        }
    }

    private void resetMemberNotificationDisabled(SocialWorkspace socialWorkspace) {
        ScopedMap contextData = socialWorkspace.getDocument().getContextData();
        contextData.putScopedValue(org.nuxeo.common.collections.ScopeType.REQUEST, MEMBER_NOTIFICATION_DISABLED, (Serializable)Boolean.valueOf(false));
    }

    public void importUserFromGroups() {
        if (this.groupsToImport != null) {
            HashSet<String> importedUsers = new HashSet<String>();
            SocialWorkspace socialWorkspace = SocialWorkspaceHelper.toSocialWorkspace((DocumentModel)this.navigationContext.getCurrentDocument());
            try {
                for (String groupName : this.groupsToImport) {
                    importedUsers.addAll(this.socialWorkspaceService.addSocialWorkspaceMembers(socialWorkspace, groupName));
                }
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(USERS_IMPORTED_LABEL), new Object[]{importedUsers.size(), this.convertToString(importedUsers)});
                this.resetGroupsToImport();
                this.resetMemberNotificationDisabled(socialWorkspace);
            }
            catch (ClientException e) {
                log.warn((Object)e, (Throwable)e);
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get(USERS_IMPORTED_ERROR_LABEL), new Object[0]);
            }
        }
    }

    protected String convertToString(Collection<String> users) {
        StringBuilder sb = new StringBuilder();
        for (String user : users) {
            sb.append(user).append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(".");
        return sb.toString();
    }

    public void resetGroupsToImport() {
        this.groupsToImport = null;
    }

    public void resetRawListOfEmails() {
        this.rawListOfEmails = null;
    }
}

