/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.computedgroups.SocialWorkspaceGroupComputer;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.security.UserManagementActions;

@Name(value="manageSocialWorkspaceActions")
@Scope(value=ScopeType.PAGE)
@Install(precedence=10)
public class ManageSocialWorkspaceActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GROUPS_SAVE_COMPLETED_LABEL = "label.social.workspace.faces.saveCompleted";
    public static final String GROUPS_SAVE_ERROR_LABEL = "label.social.workspace.faces.saveError";
    private static final Log log = LogFactory.getLog(ManageSocialWorkspaceActions.class);
    protected List<String> originalAdministrators;
    protected List<String> administrators;
    protected List<String> originalMembers;
    protected List<String> members;
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected UserManagementActions userManagementActions;
    protected SocialWorkspaceGroupComputer computer = new SocialWorkspaceGroupComputer();

    public List<String> getAdministrators() throws Exception {
        if (this.administrators == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.administrators = ActivityHelper.getUsernames((List)this.computer.getGroupMembers(SocialWorkspaceHelper.getSocialWorkspaceAdministratorsGroupName((DocumentModel)currentDocument)));
            this.originalAdministrators = this.administrators;
        }
        return this.administrators;
    }

    public List<String> getMembers() throws Exception {
        if (this.members == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.members = ActivityHelper.getUsernames((List)this.computer.getGroupMembers(SocialWorkspaceHelper.getSocialWorkspaceMembersGroupName((DocumentModel)currentDocument)));
            this.originalMembers = this.members;
        }
        return this.members;
    }

    public void updateGroups() throws ClientException {
        SocialWorkspace socialWorkspace = SocialWorkspaceHelper.toSocialWorkspace((DocumentModel)this.navigationContext.getCurrentDocument());
        for (String administrator : this.administrators) {
            if (this.originalAdministrators.contains(administrator)) continue;
            socialWorkspace.addAdministrator((Principal)this.userManager.getPrincipal(administrator));
        }
        for (String administrator : this.originalAdministrators) {
            if (this.administrators.contains(administrator)) continue;
            socialWorkspace.removeAdministrator((Principal)this.userManager.getPrincipal(administrator));
        }
        for (String member : this.members) {
            if (this.originalMembers.contains(member)) continue;
            socialWorkspace.addMember((Principal)this.userManager.getPrincipal(member));
        }
        for (String member : this.originalMembers) {
            if (this.members.contains(member)) continue;
            socialWorkspace.removeMember((Principal)this.userManager.getPrincipal(member));
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(GROUPS_SAVE_COMPLETED_LABEL), new Object[0]);
    }

    public void setAdministrators(List<String> administrators) {
        this.administrators = administrators;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public List<String> getFilteredUserVirtualGroups(String userId) throws Exception {
        List virtualGroups = this.userManagementActions.getUserVirtualGroups(userId);
        if (virtualGroups != null) {
            ArrayList<String> filteredVirtualGroups = new ArrayList<String>();
            for (String virtualGroup : virtualGroups) {
                if (virtualGroup.endsWith("_members") || virtualGroup.endsWith("_administrators")) continue;
                filteredVirtualGroups.add(virtualGroup);
            }
            return filteredVirtualGroups;
        }
        return null;
    }
}

