/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityLinkBuilder;
import org.nuxeo.ecm.activity.ActivityLinkBuilderDescriptor;
import org.nuxeo.ecm.activity.ActivityLinkBuilderRegistry;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.activity.ActivityMessageHelper;
import org.nuxeo.ecm.activity.ActivityMessageLabelDescriptor;
import org.nuxeo.ecm.activity.ActivityReply;
import org.nuxeo.ecm.activity.ActivityReplyMessage;
import org.nuxeo.ecm.activity.ActivityStream;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamFilterDescriptor;
import org.nuxeo.ecm.activity.ActivityStreamRegistry;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.activity.ActivityVerb;
import org.nuxeo.ecm.activity.ActivityVerbRegistry;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ActivityStreamServiceImpl
extends DefaultComponent
implements ActivityStreamService {
    private static final Log log = LogFactory.getLog(ActivityStreamServiceImpl.class);
    public static final String ACTIVITIES_PROVIDER = "nxactivities";
    public static final String ACTIVITY_STREAM_FILTER_EP = "activityStreamFilters";
    @Deprecated
    public static final String ACTIVITY_MESSAGE_LABELS_EP = "activityMessageLabels";
    public static final String ACTIVITY_STREAMS_EP = "activityStreams";
    public static final String ACTIVITY_VERBS_EP = "activityVerbs";
    public static final String ACTIVITY_LINK_BUILDERS_EP = "activityLinkBuilders";
    protected final ThreadLocal<EntityManager> localEntityManager = new ThreadLocal();
    protected final Map<String, ActivityStreamFilter> activityStreamFilters = new HashMap<String, ActivityStreamFilter>();
    protected ActivityStreamRegistry activityStreamRegistry;
    protected ActivityVerbRegistry activityVerbRegistry;
    protected ActivityLinkBuilderRegistry activityLinkBuilderRegistry;
    protected PersistenceProvider persistenceProvider;

    @Override
    public ActivitiesList query(String filterId, Map<String, Serializable> parameters) {
        return this.query(filterId, parameters, 0L, 0L);
    }

    @Override
    public ActivitiesList query(String filterId, Map<String, Serializable> parameters, long offset, long limit) {
        if ("allActivities".equals(filterId)) {
            return this.queryAll(offset, limit);
        }
        ActivityStreamFilter filter = this.activityStreamFilters.get(filterId);
        if (filter == null) {
            throw new ClientRuntimeException(String.format("Unable to retrieve '%s' ActivityStreamFilter", filterId));
        }
        return this.query(filter, parameters, offset, limit);
    }

    protected ActivitiesList query(final ActivityStreamFilter filter, final Map<String, Serializable> parameters, final long offset, final long limit) {
        try {
            return (ActivitiesList)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<ActivitiesList>(){

                public ActivitiesList runWith(EntityManager em) {
                    return ActivityStreamServiceImpl.this.query(em, filter, parameters, offset, limit);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActivitiesList query(EntityManager em, ActivityStreamFilter filter, Map<String, Serializable> parameters, long offset, long limit) {
        try {
            this.localEntityManager.set(em);
            ActivitiesList activitiesList = filter.query(this, parameters, offset, limit);
            return activitiesList;
        }
        finally {
            this.localEntityManager.remove();
        }
    }

    protected ActivitiesList queryAll(final long offset, final long limit) {
        try {
            return (ActivitiesList)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<ActivitiesList>(){

                public ActivitiesList runWith(EntityManager em) {
                    return ActivityStreamServiceImpl.this.queryAll(em, offset, limit);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected ActivitiesList queryAll(EntityManager em, long offset, long limit) {
        Query query = em.createQuery("select activity from Activity activity order by activity.id asc");
        if (limit > 0L) {
            query.setMaxResults((int)limit);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
        }
        return new ActivitiesListImpl(query.getResultList());
    }

    @Override
    public Activity addActivity(final Activity activity) {
        if (activity.getPublishedDate() == null) {
            activity.setPublishedDate(new Date());
        }
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    ActivityStreamServiceImpl.this.addActivity(em, activity);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addActivity(EntityManager em, Activity activity) {
        try {
            this.localEntityManager.set(em);
            em.persist((Object)activity);
            for (ActivityStreamFilter filter : this.activityStreamFilters.values()) {
                if (!filter.isInterestedIn(activity)) continue;
                filter.handleNewActivity(this, activity);
            }
        }
        finally {
            this.localEntityManager.remove();
        }
    }

    @Override
    public void removeActivities(final Collection<Activity> activities) {
        if (activities == null || activities.isEmpty()) {
            return;
        }
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    ActivityStreamServiceImpl.this.removeActivities(em, activities);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeActivities(EntityManager em, Collection<Activity> activities) {
        try {
            this.localEntityManager.set(em);
            ActivitiesListImpl l = new ActivitiesListImpl((Collection<? extends Activity>)activities);
            for (ActivityStreamFilter filter : this.activityStreamFilters.values()) {
                filter.handleRemovedActivities((ActivityStreamService)this, l);
            }
            Query query = em.createQuery("delete from Activity activity where activity.id in (:ids)");
            query.setParameter("ids", l.toActivityIds());
            query.executeUpdate();
        }
        finally {
            this.localEntityManager.remove();
        }
    }

    @Override
    public ActivityMessage toActivityMessage(Activity activity, Locale locale) {
        return this.toActivityMessage(activity, locale, null);
    }

    @Override
    public ActivityMessage toActivityMessage(Activity activity, Locale locale, String activityLinkBuilderName) {
        String messageTemplate;
        String displayActorLink;
        ActivityLinkBuilder activityLinkBuilder = this.getActivityLinkBuilder(activityLinkBuilderName);
        Map<String, String> fields = activity.toMap();
        String actor = activity.getActor();
        String displayActor = activity.getDisplayActor();
        if (ActivityHelper.isUser(actor)) {
            try {
                displayActorLink = activityLinkBuilder.getUserProfileLink(actor, activity.getDisplayActor());
            }
            catch (Exception e) {
                displayActorLink = activity.getDisplayActor();
            }
        } else {
            displayActorLink = activity.getDisplayActor();
        }
        List<ActivityReplyMessage> activityReplyMessages = this.toActivityReplyMessages(activity.getActivityReplies(), locale, activityLinkBuilderName);
        ActivityVerb verb = this.activityVerbRegistry.get(activity.getVerb());
        if (verb == null || verb.getLabelKey() == null) {
            return new ActivityMessage(activity.getId(), actor, displayActor, displayActorLink, activity.getVerb(), activity.toString(), activity.getPublishedDate(), null, activityReplyMessages);
        }
        String labelKey = verb.getLabelKey();
        try {
            messageTemplate = I18NUtils.getMessageString((String)"messages", (String)labelKey, null, (Locale)locale);
        }
        catch (MissingResourceException e) {
            log.error((Object)e.getMessage());
            log.debug((Object)e, (Throwable)e);
            return new ActivityMessage(activity.getId(), actor, displayActor, displayActorLink, activity.getVerb(), labelKey, activity.getPublishedDate(), verb.getIcon(), activityReplyMessages);
        }
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher m = pattern.matcher(messageTemplate);
        while (m.find()) {
            String param = m.group().replaceAll("[\\|$\\|{\\}]", "");
            if (!fields.containsKey(param)) continue;
            String value = fields.get(param);
            String displayValue = fields.get("display" + StringUtils.capitalize((String)param));
            value = ActivityHelper.isDocument(value) ? activityLinkBuilder.getDocumentLink(value, displayValue) : (ActivityHelper.isUser(value) ? activityLinkBuilder.getUserProfileLink(value, displayValue) : ActivityMessageHelper.replaceURLsByLinks(value));
            messageTemplate = messageTemplate.replace(m.group(), value);
        }
        return new ActivityMessage(activity.getId(), actor, displayActor, displayActorLink, activity.getVerb(), messageTemplate, activity.getPublishedDate(), verb.getIcon(), activityReplyMessages);
    }

    @Override
    public ActivityLinkBuilder getActivityLinkBuilder(String name) {
        ActivityLinkBuilder activityLinkBuilder;
        if (StringUtils.isBlank((String)name)) {
            activityLinkBuilder = this.activityLinkBuilderRegistry.getDefaultActivityLinkBuilder();
        } else {
            activityLinkBuilder = this.activityLinkBuilderRegistry.get(name);
            if (activityLinkBuilder == null) {
                log.warn((Object)"Fallback on default Activity link builder");
                activityLinkBuilder = this.activityLinkBuilderRegistry.getDefaultActivityLinkBuilder();
            }
        }
        return activityLinkBuilder;
    }

    @Override
    public ActivityReplyMessage toActivityReplyMessage(ActivityReply activityReply, Locale locale) {
        return this.toActivityReplyMessage(activityReply, locale, null);
    }

    @Override
    public ActivityReplyMessage toActivityReplyMessage(ActivityReply activityReply, Locale locale, String activityLinkBuilderName) {
        ActivityLinkBuilder activityLinkBuilder = this.getActivityLinkBuilder(activityLinkBuilderName);
        String actor = activityReply.getActor();
        String displayActor = activityReply.getDisplayActor();
        String displayActorLink = activityLinkBuilder.getUserProfileLink(actor, displayActor);
        String message = ActivityMessageHelper.replaceURLsByLinks(activityReply.getMessage());
        return new ActivityReplyMessage(activityReply.getId(), actor, displayActor, displayActorLink, message, activityReply.getPublishedDate());
    }

    private List<ActivityReplyMessage> toActivityReplyMessages(List<ActivityReply> replies, Locale locale, String activityLinkBuilderName) {
        ArrayList<ActivityReplyMessage> activityReplyMessages = new ArrayList<ActivityReplyMessage>();
        for (ActivityReply reply : replies) {
            activityReplyMessages.add(this.toActivityReplyMessage(reply, locale, activityLinkBuilderName));
        }
        return activityReplyMessages;
    }

    @Override
    public ActivityStream getActivityStream(String name) {
        return this.activityStreamRegistry.get(name);
    }

    @Override
    public ActivityReply addActivityReply(Serializable activityId, ActivityReply activityReply) {
        Activity activity = this.getActivity(activityId);
        if (activity != null) {
            List<ActivityReply> replies = activity.getActivityReplies();
            String newReplyId = this.computeNewReplyId(activity);
            activityReply.setId(newReplyId);
            replies.add(activityReply);
            activity.setActivityReplies(replies);
            this.updateActivity(activity);
        }
        return activityReply;
    }

    protected String computeNewReplyId(Activity activity) {
        String replyIdPrefix = activity.getId() + "-reply-";
        List<ActivityReply> replies = activity.getActivityReplies();
        long maxId = 0L;
        for (ActivityReply reply : replies) {
            String replyId = reply.getId();
            long currentId = Long.valueOf(replyId.replace(replyIdPrefix, ""));
            if (currentId <= maxId) continue;
            maxId = currentId;
        }
        return replyIdPrefix + (maxId + 1L);
    }

    @Override
    public Activity getActivity(final Serializable activityId) {
        try {
            return (Activity)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Activity>(){

                public Activity runWith(EntityManager em) {
                    return ActivityStreamServiceImpl.this.getActivity(em, activityId);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public ActivitiesList getActivities(final Collection<Serializable> activityIds) {
        try {
            return (ActivitiesList)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<ActivitiesList>(){

                public ActivitiesList runWith(EntityManager em) {
                    return ActivityStreamServiceImpl.this.getActivities(em, activityIds);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public ActivityReply removeActivityReply(final Serializable activityId, final String activityReplyId) {
        try {
            return (ActivityReply)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<ActivityReply>(){

                public ActivityReply runWith(EntityManager em) {
                    return ActivityStreamServiceImpl.this.removeActivityReply(em, activityId, activityReplyId);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActivityReply removeActivityReply(EntityManager em, Serializable activityId, String activityReplyId) {
        try {
            this.localEntityManager.set(em);
            Activity activity = this.getActivity(activityId);
            if (activity != null) {
                List<ActivityReply> replies = activity.getActivityReplies();
                Iterator<ActivityReply> it = replies.iterator();
                while (it.hasNext()) {
                    ActivityReply reply = it.next();
                    if (!reply.getId().equals(activityReplyId)) continue;
                    for (ActivityStreamFilter filter : this.activityStreamFilters.values()) {
                        filter.handleRemovedActivityReply(this, activity, reply);
                    }
                    it.remove();
                    activity.setActivityReplies(replies);
                    this.updateActivity(activity);
                    ActivityReply activityReply = reply;
                    return activityReply;
                }
            }
            ActivityReply activityReply = null;
            return activityReply;
        }
        finally {
            this.localEntityManager.remove();
        }
    }

    protected Activity getActivity(EntityManager em, Serializable activityId) {
        Query query = em.createQuery("select activity from Activity activity where activity.id = :activityId");
        query.setParameter("activityId", (Object)activityId);
        return (Activity)query.getSingleResult();
    }

    protected ActivitiesList getActivities(EntityManager em, Collection<Serializable> activityIds) {
        Query query = em.createQuery("select activity from Activity activity where activity.id in (:ids)");
        query.setParameter("ids", activityIds);
        return new ActivitiesListImpl(query.getResultList());
    }

    protected void updateActivity(final Activity activity) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Activity>(){

                public Activity runWith(EntityManager em) {
                    activity.setLastUpdatedDate(new Date());
                    return (Activity)em.merge((Object)activity);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public EntityManager getEntityManager() {
        return this.localEntityManager.get();
    }

    public PersistenceProvider getOrCreatePersistenceProvider() {
        if (this.persistenceProvider == null) {
            this.activatePersistenceProvider();
        }
        return this.persistenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activatePersistenceProvider() {
        Thread thread = Thread.currentThread();
        ClassLoader last = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(PersistenceProvider.class.getClassLoader());
            PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
            this.persistenceProvider = persistenceProviderFactory.newProvider(ACTIVITIES_PROVIDER);
            this.persistenceProvider.openPersistenceUnit();
        }
        finally {
            thread.setContextClassLoader(last);
        }
    }

    protected void deactivatePersistenceProvider() {
        if (this.persistenceProvider != null) {
            this.persistenceProvider.closePersistenceUnit();
            this.persistenceProvider = null;
        }
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.activityStreamRegistry = new ActivityStreamRegistry();
        this.activityVerbRegistry = new ActivityVerbRegistry();
        this.activityLinkBuilderRegistry = new ActivityLinkBuilderRegistry();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.deactivatePersistenceProvider();
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ACTIVITY_STREAM_FILTER_EP.equals(extensionPoint)) {
            this.registerActivityStreamFilter((ActivityStreamFilterDescriptor)contribution);
        } else if (ACTIVITY_MESSAGE_LABELS_EP.equals(extensionPoint)) {
            this.registerActivityMessageLabel((ActivityMessageLabelDescriptor)contribution);
        } else if (ACTIVITY_STREAMS_EP.equals(extensionPoint)) {
            this.registerActivityStream((ActivityStream)contribution);
        } else if (ACTIVITY_VERBS_EP.equals(extensionPoint)) {
            this.registerActivityVerb((ActivityVerb)contribution);
        } else if (ACTIVITY_LINK_BUILDERS_EP.equals(extensionPoint)) {
            this.registerActivityLinkBuilder((ActivityLinkBuilderDescriptor)contribution);
        }
    }

    private void registerActivityStreamFilter(ActivityStreamFilterDescriptor descriptor) throws ClientException {
        ActivityStreamFilter filter = descriptor.getActivityStreamFilter();
        String filterId = filter.getId();
        boolean enabled = descriptor.isEnabled();
        if (this.activityStreamFilters.containsKey(filterId)) {
            log.info((Object)("Overriding activity stream filter with id " + filterId));
            if (!enabled) {
                this.activityStreamFilters.remove(filterId);
                log.info((Object)("Disabled activity stream filter with id " + filterId));
            }
        }
        if (enabled) {
            log.info((Object)("Registering activity stream filter with id " + filterId));
            this.activityStreamFilters.put(filterId, descriptor.getActivityStreamFilter());
        }
    }

    private void registerActivityMessageLabel(ActivityMessageLabelDescriptor descriptor) {
        log.info((Object)("Registering activity message label for verb" + descriptor.getActivityVerb()));
        log.warn((Object)"The 'activityMessageLabels' extension point is deprecated, please use the 'activityVerbs' extension point.");
        ActivityVerb activityVerb = new ActivityVerb();
        activityVerb.setVerb(descriptor.getActivityVerb());
        activityVerb.setLabelKey(descriptor.getLabelKey());
        this.registerActivityVerb(activityVerb);
    }

    private void registerActivityStream(ActivityStream activityStream) {
        log.info((Object)String.format("Registering activity stream '%s'", activityStream.getName()));
        this.activityStreamRegistry.addContribution(activityStream);
    }

    private void registerActivityVerb(ActivityVerb activityVerb) {
        log.info((Object)String.format("Registering activity verb '%s'", activityVerb.getVerb()));
        this.activityVerbRegistry.addContribution(activityVerb);
    }

    private void registerActivityLinkBuilder(ActivityLinkBuilderDescriptor activityLinkBuilderDescriptor) {
        log.info((Object)String.format("Registering activity link builder '%s'", activityLinkBuilderDescriptor.getName()));
        this.activityLinkBuilderRegistry.addContribution(activityLinkBuilderDescriptor);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ACTIVITY_STREAM_FILTER_EP.equals(extensionPoint)) {
            this.unregisterActivityStreamFilter((ActivityStreamFilterDescriptor)contribution);
        } else if (ACTIVITY_MESSAGE_LABELS_EP.equals(extensionPoint)) {
            this.unregisterActivityMessageLabel((ActivityMessageLabelDescriptor)contribution);
        } else if (ACTIVITY_STREAMS_EP.equals(extensionPoint)) {
            this.unregisterActivityStream((ActivityStream)contribution);
        } else if (ACTIVITY_VERBS_EP.equals(extensionPoint)) {
            this.unregisterActivityVerb((ActivityVerb)contribution);
        } else if (ACTIVITY_LINK_BUILDERS_EP.equals(extensionPoint)) {
            this.unregisterActivityLinkBuilder((ActivityLinkBuilderDescriptor)contribution);
        }
    }

    private void unregisterActivityStreamFilter(ActivityStreamFilterDescriptor descriptor) throws ClientException {
        ActivityStreamFilter filter = descriptor.getActivityStreamFilter();
        String filterId = filter.getId();
        this.activityStreamFilters.remove(filterId);
        log.info((Object)("Unregistering activity stream filter with id " + filterId));
    }

    private void unregisterActivityMessageLabel(ActivityMessageLabelDescriptor descriptor) {
        ActivityVerb activityVerb = new ActivityVerb();
        activityVerb.setVerb(descriptor.getActivityVerb());
        activityVerb.setLabelKey(descriptor.getLabelKey());
        this.unregisterActivityVerb(activityVerb);
        log.info((Object)("Unregistering activity message label for verb " + activityVerb));
        log.warn((Object)"The 'activityMessageLabels' extension point is deprecated, please use the 'activityVerbs' extension point.");
    }

    private void unregisterActivityStream(ActivityStream activityStream) {
        this.activityStreamRegistry.removeContribution(activityStream);
        log.info((Object)String.format("Unregistering activity stream '%s'", activityStream.getName()));
    }

    private void unregisterActivityVerb(ActivityVerb activityVerb) {
        this.activityVerbRegistry.removeContribution(activityVerb);
        log.info((Object)String.format("Unregistering activity verb '%s'", activityVerb.getVerb()));
    }

    private void unregisterActivityLinkBuilder(ActivityLinkBuilderDescriptor activityLinkBuilderDescriptor) {
        this.activityLinkBuilderRegistry.removeContribution(activityLinkBuilderDescriptor);
        log.info((Object)String.format("Unregistering activity link builder '%s'", activityLinkBuilderDescriptor.getName()));
    }
}

