/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.wall;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.AbstractActivityPageProvider;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class WallActivityStreamPageProvider
extends AbstractActivityPageProvider<ActivityMessage> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(WallActivityStreamPageProvider.class);
    public static final String ACTIVITY_STREAM_NAME_PROPERTY = "activityStreamName";
    public static final String ACTIVITY_LINK_BUILDER_NAME_PROPERTY = "activityLinkBuilderName";
    public static final String CONTEXT_DOCUMENT_PROPERTY = "contextDocument";
    public static final String LOCALE_PROPERTY = "locale";
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    protected List<ActivityMessage> pageActivityMessages;

    public List<ActivityMessage> getCurrentPage() {
        if (this.pageActivityMessages == null) {
            this.pageActivityMessages = new ArrayList<ActivityMessage>();
            long pageSize = this.getMinMaxPageSize();
            ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("activityStreamParameter", this.getActivityStreamName());
            parameters.put("contextDocumentParameter", (String)this.getContextDocument());
            ActivitiesList activities = activityStreamService.query("WallActivityStreamFilter", parameters, this.getCurrentPageOffset(), pageSize);
            this.nextOffset = this.offset + (long)activities.size();
            activities = activities.filterActivities(this.getCoreSession());
            this.pageActivityMessages.addAll(activities.toActivityMessages(this.getLocale(), this.getActivityLinkBuilderName()));
            this.setResultsCount(-2L);
        }
        return this.pageActivityMessages;
    }

    protected String getActivityStreamName() {
        Map props = this.getProperties();
        String activityStreamName = (String)props.get(ACTIVITY_STREAM_NAME_PROPERTY);
        if (activityStreamName == null) {
            throw new ClientRuntimeException("Cannot find activityStreamName property.");
        }
        return activityStreamName;
    }

    protected DocumentModel getContextDocument() {
        Map props = this.getProperties();
        DocumentModel contextDocument = (DocumentModel)props.get(CONTEXT_DOCUMENT_PROPERTY);
        if (contextDocument == null) {
            throw new ClientRuntimeException("Cannot find contextDocument property.");
        }
        return contextDocument;
    }

    protected Locale getLocale() {
        Map props = this.getProperties();
        Locale locale = (Locale)props.get(LOCALE_PROPERTY);
        if (locale == null) {
            throw new ClientRuntimeException("Cannot find locale property.");
        }
        return locale;
    }

    protected String getActivityLinkBuilderName() {
        Map props = this.getProperties();
        return (String)props.get(ACTIVITY_LINK_BUILDER_NAME_PROPERTY);
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession session = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (session == null) {
            throw new ClientRuntimeException("Cannot find coreSession property.");
        }
        return session;
    }

    public boolean isSortable() {
        return false;
    }

    protected void pageChanged() {
        super.pageChanged();
        this.pageActivityMessages = null;
    }

    public void refresh() {
        super.refresh();
        this.pageActivityMessages = null;
    }
}

