/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentIdCodec;
import org.nuxeo.ecm.platform.url.codec.DocumentPathCodec;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class CollaborationCodec
extends AbstractDocumentViewCodec {
    private static final Log log = LogFactory.getLog(CollaborationCodec.class);
    public static final String PREFIX = "collaboration";
    public static final String ID_URL_PATTERN = "/(\\w+)/([a-zA-Z_0-9\\-]+)(/([a-zA-Z_0-9\\-\\.]*))?(/)?(\\?(.*)?)?";
    public static final String PATH_URL_PATTERN = "/([\\w\\.]+)(?:/(.*))?@([\\w\\-\\.]+)/?(?:\\?(.*)?)?";

    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + ID_URL_PATTERN);
        Matcher m = pattern.matcher(url);
        if (m.matches()) {
            DocumentIdCodec idCodec = new DocumentIdCodec();
            idCodec.setPrefix(this.getPrefix());
            DocumentView docView = idCodec.getDocumentViewFromUrl(url);
            this.updateDocumentView(docView);
            return docView;
        }
        pattern = Pattern.compile(this.getPrefix() + PATH_URL_PATTERN);
        m = pattern.matcher(url);
        if (m.matches()) {
            DocumentPathCodec pathCodec = new DocumentPathCodec();
            pathCodec.setPrefix(this.getPrefix());
            return pathCodec.getDocumentViewFromUrl(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentView updateDocumentView(final DocumentView docView) {
        boolean transactionStarted = false;
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
            transactionStarted = true;
        }
        try {
            DocumentLocation docLoc = docView.getDocumentLocation();
            new UnrestrictedSessionRunner(docLoc.getServerName()){

                public void run() throws ClientException {
                    CollaborationCodec.this.computeDocumentView(this.session, docView);
                }
            }.runUnrestricted();
        }
        catch (ClientException clientException) {
        }
        finally {
            if (transactionStarted) {
                TransactionHelper.commitOrRollbackTransaction();
            }
        }
        return docView;
    }

    protected DocumentView computeDocumentView(CoreSession session, DocumentView docView) throws ClientException {
        DocumentModel doc = session.getDocument(docView.getDocumentLocation().getDocRef());
        if (doc.hasFacet("SocialWorkspace")) {
            docView.setDocumentLocation((DocumentLocation)new DocumentLocationImpl(session.getChild(doc.getRef(), "social")));
            docView.setViewId("social_dashboard");
        } else {
            TypeManager typeService = (TypeManager)Framework.getLocalService(TypeManager.class);
            Type type = typeService.getType(doc.getType());
            if (doc.hasFacet("Folderish") || !typeService.getAllowedSubTypes("SocialWorkspace").contains(type)) {
                docView.setViewId(type.getDefaultView());
                docView.addParameter("tabIds", "MAIN_TAB:documents");
            }
        }
        return docView;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        DocumentLocation documentLocation = docView.getDocumentLocation();
        if (documentLocation.getPathRef() != null) {
            DocumentPathCodec pathCodec = new DocumentPathCodec();
            pathCodec.setPrefix(this.getPrefix());
            return pathCodec.getUrlFromDocumentView(docView);
        }
        DocumentIdCodec idCodec = new DocumentIdCodec();
        idCodec.setPrefix(this.getPrefix());
        docView.setViewId("view_social_document");
        return idCodec.getUrlFromDocumentView(docView);
    }
}

