/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

@Name(value="socialWorkspaceActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class SocialWorkspaceActions
implements Serializable {
    public static final String MAIN_TABS_COLLABORATION = "MAIN_TABS:collaboration";
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient SocialWorkspaceService socialWorkspaceService;
    @In(create=true)
    protected transient NuxeoPrincipal currentUser;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient WebActions webActions;

    public static SocialWorkspace toSocialWorkspace(DocumentModel doc) {
        return SocialWorkspaceHelper.toSocialWorkspace((DocumentModel)doc);
    }

    public boolean isCurrentUserAdministratorOrMemberOfCurrentSocialWorkspace() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(doc);
        return socialWorkspace != null && socialWorkspace.isAdministratorOrMember(this.currentUser);
    }

    public boolean isCurrentUserAdministratorOfCurrentSocialWorkspace() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(doc);
        return socialWorkspace != null && socialWorkspace.isAdministrator(this.currentUser);
    }

    public boolean enableSocialWorkspaceActions() throws ClientException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (list.isEmpty()) {
            return false;
        }
        for (DocumentModel doc : list) {
            if ("project".equals(doc.getCurrentLifeCycleState())) continue;
            return false;
        }
        return true;
    }

    public SocialWorkspace getSocialWorkspace(DocumentModel doc) {
        return this.socialWorkspaceService.getDetachedSocialWorkspace(doc);
    }

    public SocialWorkspace getSocialWorkspace() {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return this.getSocialWorkspace(doc);
    }

    public DocumentModel getSocialWorkspaceContainer() {
        return this.socialWorkspaceService.getSocialWorkspaceContainer(this.documentManager);
    }

    public String getCollaborationMainTab() {
        return MAIN_TABS_COLLABORATION;
    }

    public void setCollaborationMainTab(String tabs) {
        this.webActions.setCurrentTabIds(!StringUtils.isBlank((String)tabs) ? tabs : MAIN_TABS_COLLABORATION);
    }
}

