/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.spaces;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.spaces.api.AbstractSpaceProvider;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.helper.WebContentHelper;
import org.nuxeo.ecm.user.center.dashboard.AbstractDashboardSpaceCreator;
import org.nuxeo.runtime.api.Framework;

public class CollaborationDashboardSpaceProvider
extends AbstractSpaceProvider {
    private static final Log log = LogFactory.getLog(CollaborationDashboardSpaceProvider.class);

    public boolean isReadOnly(CoreSession session) {
        return false;
    }

    protected Space doGetSpace(CoreSession session, DocumentModel contextDocument, String spaceName, Map<String, String> parameters) throws SpaceException {
        try {
            return this.getOrCreateSpace(session, parameters);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to create or get collaboration dashboard", (Throwable)e);
            return null;
        }
    }

    protected Space getOrCreateSpace(CoreSession session, Map<String, String> parameters) throws ClientException {
        DocumentModel socialWorkspaceContainer = this.getSocialWorkspaceService().getSocialWorkspaceContainer(session);
        PathRef collaborationDashboardSpaceRef = new PathRef(socialWorkspaceContainer.getPathAsString(), "collaborationDashboardSpace");
        if (session.exists((DocumentRef)collaborationDashboardSpaceRef)) {
            DocumentModel collaborationDashboardSpace = session.getDocument((DocumentRef)collaborationDashboardSpaceRef);
            return (Space)collaborationDashboardSpace.getAdapter(Space.class);
        }
        DocumentModel collaborationDashboardSpace = this.getOrCreateCollaborationDashboardSpace(session, parameters);
        return (Space)collaborationDashboardSpace.getAdapter(Space.class);
    }

    protected DocumentModel getOrCreateCollaborationDashboardSpace(CoreSession session, Map<String, String> parameters) throws ClientException {
        CollaborationDashBoardSpaceCreator creator = new CollaborationDashBoardSpaceCreator(session, parameters);
        creator.runUnrestricted();
        return session.getDocument(creator.getCollaborationDashboardSpaceRef());
    }

    protected SocialWorkspaceService getSocialWorkspaceService() {
        return (SocialWorkspaceService)Framework.getLocalService(SocialWorkspaceService.class);
    }

    class CollaborationDashBoardSpaceCreator
    extends AbstractDashboardSpaceCreator {
        DocumentRef collaborationDashboardSpaceRef;

        protected CollaborationDashBoardSpaceCreator(CoreSession session, Map<String, String> parameters) {
            super(session, parameters);
        }

        public DocumentRef getCollaborationDashboardSpaceRef() {
            return this.collaborationDashboardSpaceRef;
        }

        public void run() throws ClientException {
            DocumentModel socialWorkspaceContainer = CollaborationDashboardSpaceProvider.this.getSocialWorkspaceService().getSocialWorkspaceContainer(this.session);
            DocumentModel collaborationDashboardSpace = this.session.createDocumentModel(socialWorkspaceContainer.getPathAsString(), "collaborationDashboardSpace", "Space");
            collaborationDashboardSpace.setPropertyValue("dc:title", (Serializable)((Object)"global dashboard space"));
            collaborationDashboardSpace.setPropertyValue("dc:description", (Serializable)((Object)"global dashboard space"));
            collaborationDashboardSpace = this.session.createDocument(collaborationDashboardSpace);
            this.addInitialGadgets(collaborationDashboardSpace);
            this.collaborationDashboardSpaceRef = collaborationDashboardSpace.getRef();
        }

        protected void initializeGadgets(Space space, CoreSession session, Locale locale) throws ClientException {
            WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"publicsocialworkspaces", (int)0, (int)0, (int)0);
            WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"news", (int)0, (int)0, (int)1);
            WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"usersocialworkspaces", (int)0, (int)1, (int)0);
            WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"useractivitystream", (int)0, (int)1, (int)1);
        }
    }
}

