/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message;

import java.io.Serializable;
import java.util.Date;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityMessageHelper;
import org.nuxeo.ecm.social.mini.message.MiniMessageHelper;

public final class MiniMessage {
    private Serializable id;
    private String actor;
    private String displayActor;
    private String message;
    private Date publishedDate;

    private MiniMessage(Serializable id, String actor, String displayActor, String message, Date publishedDate) {
        this.id = id;
        this.actor = actor;
        this.displayActor = displayActor;
        this.message = message;
        this.publishedDate = publishedDate;
    }

    public static MiniMessage fromActivity(Activity activity) {
        String message = MiniMessageHelper.replaceURLsByLinks(activity.getObject());
        return new MiniMessage(activity.getId(), ActivityHelper.getUsername((String)activity.getActor()), ActivityMessageHelper.getUserProfileLink((String)activity.getActor(), (String)activity.getDisplayActor()), message, activity.getPublishedDate());
    }

    public Serializable getId() {
        return this.id;
    }

    public String getActor() {
        return this.actor;
    }

    public String getDisplayActor() {
        return this.displayActor;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getPublishedDate() {
        return this.publishedDate;
    }
}

